/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.CategoryInfo;

public class CategoriesRestClient {
    private static final String CATEGORIES_URL = "categories";
    private final RestInvokerManager restInvokerManager;

    public CategoriesRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countCategories() {
        return this.restInvokerManager.getRestInvoker().invokeGet("categories/count", Long.class);
    }

    public Boolean existsCategory(String categoryId) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("categories/{0}/exists", categoryId), Boolean.class);
    }

    public List<CategoryInfo> getCategories() {
        ParameterizedTypeReference<List<CategoryInfo>> returnTypeRef = new ParameterizedTypeReference<List<CategoryInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(CATEGORIES_URL, returnTypeRef);
    }

    public List<CategoryInfo> getCategories(int page, int size) {
        ParameterizedTypeReference<List<CategoryInfo>> returnTypeRef = new ParameterizedTypeReference<List<CategoryInfo>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("categories?page=" + page + "&size=" + size, returnTypeRef);
    }

    public CategoryInfo getCategory(String categoryId) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("categories/{0}", categoryId), CategoryInfo.class);
    }
}

