/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.domain.java.discountsystem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Counter;
import su.artix.loyaltylib.domain.java.discountsystem.Coupon;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.Gift;
import su.artix.loyaltylib.domain.java.discountsystem.PositionMark;
import su.artix.loyaltylib.domain.java.discountsystem.Report;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.DiscountTreeTypeAction;
import su.artix.loyaltylib.domain.java.observable.Named;

public class Discount
extends AbstractDiscountModel
implements Serializable,
Named {
    private static final long serialVersionUID = 1L;
    @NotNull
    private Long id;
    private String name;
    private String typeOfDiscount;
    private DiscountObject discountObject;
    private List<DiscountCondition> discountConditions = new ArrayList<DiscountCondition>();
    private DiscountRate discountRate;
    private String clientText;
    private String clientDisplayText;
    private String cashText;
    private List<Report> reports = new ArrayList<Report>();
    private Boolean showCashTextToConsultant;
    private Boolean minPriceIgnored = false;
    private Boolean active = true;
    private List<Coupon> coupons = new ArrayList<Coupon>();
    private List<Counter> counters = new ArrayList<Counter>();
    private List<Gift> gifts = new ArrayList<Gift>();
    private List<PositionMark> discountMarks = new ArrayList<PositionMark>();

    public Discount(String name) {
        this.name = name;
    }

    public Discount(String name, DiscountRate rate) {
        this.name = name;
        this.discountRate = rate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        if (!ObjectUtils.equals((Object)this.id, (Object)id)) {
            this.id = id;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public DiscountObject getDiscountObject() {
        return this.discountObject;
    }

    public List<DiscountCondition> getDiscountConditions() {
        return this.discountConditions;
    }

    public DiscountRate getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(DiscountRate discountRate) {
        DiscountRate oldVal = this.discountRate;
        discountRate.setParent(this);
        this.discountRate = discountRate;
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), oldVal, discountRate);
    }

    public void addDiscountObject(DiscountObject dobj) {
        dobj.setParent(this);
        DiscountObject oldVal = this.discountObject;
        this.discountObject = dobj;
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), oldVal, this.discountObject);
    }

    public void addDiscountCondition(DiscountCondition dc) {
        dc.setParent(this);
        this.discountConditions.add(dc);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, dc);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.equals((CharSequence)this.name, (CharSequence)name)) {
            this.name = name;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getClientText() {
        return this.clientText;
    }

    public void setClientText(String clientText) {
        if (!StringUtils.equals((CharSequence)this.clientText, (CharSequence)clientText)) {
            this.clientText = clientText;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getClientDisplayText() {
        return this.clientDisplayText;
    }

    public void setClientDisplayText(String clientDisplayText) {
        if (!StringUtils.equals((CharSequence)this.clientDisplayText, (CharSequence)clientDisplayText)) {
            this.clientDisplayText = clientDisplayText;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String getCashText() {
        return this.cashText;
    }

    public void setCashText(String cashText) {
        if (!StringUtils.equals((CharSequence)this.cashText, (CharSequence)cashText)) {
            this.cashText = cashText;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public void deleteDiscountCondition(DiscountCondition condition) {
        this.getDiscountConditions().remove(condition);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, condition);
    }

    public void deleteCounter(Counter counter) {
        this.getCounters().remove(counter);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, counter);
    }

    public void deleteCoupon(Coupon coupon) {
        this.getCoupons().remove(coupon);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, coupon);
    }

    public void deleteGift(Gift gift) {
        this.getGifts().remove(gift);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, gift);
    }

    public void deleteReport(Report report) {
        this.getReports().remove(report);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, report);
    }

    public void deleteDiscountRate() {
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), this.discountRate, this.discountRate);
        this.discountRate = null;
    }

    public void deleteDiscountObject() {
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), this.discountObject, this.discountObject);
        this.discountObject = null;
    }

    @Override
    public String getNameTreeNode() {
        return "[" + this.name + "]";
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        if (!ObjectUtils.equals((Object)this.active, (Object)active)) {
            this.active = active;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Discount [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", discountObject=");
        builder.append(this.discountObject);
        builder.append(", discountConditions=");
        builder.append(this.discountConditions);
        builder.append(", discountRate=");
        builder.append(this.discountRate);
        builder.append(", reports=");
        builder.append(this.reports);
        builder.append(", clientText=");
        builder.append(this.clientText);
        builder.append(", clientDisplayText=");
        builder.append(this.clientDisplayText);
        builder.append(", cashText=");
        builder.append(this.cashText);
        builder.append(", showCashTextToConsultant=");
        builder.append(this.showCashTextToConsultant);
        builder.append(", minPriceIgnored=");
        builder.append(this.minPriceIgnored);
        builder.append(", coupons=");
        builder.append(this.coupons);
        builder.append(", counters=");
        builder.append(this.counters);
        builder.append("]");
        builder.append(", gifts=");
        builder.append(this.gifts);
        builder.append(", discountMarks=");
        builder.append(this.discountMarks);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.discountRate == null ? 0 : this.discountRate.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Discount other = (Discount)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.discountRate == null ? other.discountRate != null : !this.discountRate.equals(other.discountRate)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void refresh() {
        this.firePropertyChange(DiscountTreeTypeAction.REFRESH.toString(), null, this);
    }

    public void setShowCashTextToConsultant(Boolean showCashTextToConsultant) {
        if (!ObjectUtils.equals((Object)this.showCashTextToConsultant, (Object)showCashTextToConsultant)) {
            this.showCashTextToConsultant = showCashTextToConsultant;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Boolean getShowCashTextToConsultant() {
        return this.showCashTextToConsultant;
    }

    public void setMinPriceIgnored(Boolean minPriceIgnored) {
        if (!ObjectUtils.equals((Object)this.minPriceIgnored, (Object)minPriceIgnored)) {
            this.minPriceIgnored = minPriceIgnored;
            this.firePropertyChange(DiscountTreeTypeAction.SAVE.toString(), "", this);
        }
    }

    public Boolean getMinPriceIgnored() {
        return this.minPriceIgnored;
    }

    public String getTypeOfDiscount() {
        return this.typeOfDiscount;
    }

    public void setTypeOfDiscount(String typeOfDiscount) {
        this.typeOfDiscount = typeOfDiscount;
    }

    public List<Coupon> getCoupons() {
        return this.coupons;
    }

    public void addCoupon(Coupon coupon) {
        coupon.setParent(this);
        this.coupons.add(coupon);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, coupon);
    }

    public void addReport(Report report) {
        report.setParent(this);
        this.reports.add(report);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, report);
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public List<Counter> getCounters() {
        return this.counters;
    }

    public void addCounter(Counter counter) {
        counter.setParent(this);
        this.counters.add(counter);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, counter);
    }

    public List<Gift> getGifts() {
        return this.gifts;
    }

    public void addGift(Gift gift) {
        gift.setParent(this);
        this.gifts.add(gift);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, gift);
    }

    public void addDiscountMark(PositionMark positionMark) {
        positionMark.setParent(this);
        this.discountMarks.add(positionMark);
        this.firePropertyChange(DiscountTreeTypeAction.ADD.toString(), null, positionMark);
    }

    public void deleteDiscountMarks(PositionMark positionMark) {
        this.getDiscountMarks().remove(positionMark);
        this.firePropertyChange(DiscountTreeTypeAction.REMOVE.toString(), null, positionMark);
    }

    public List<PositionMark> getDiscountMarks() {
        return this.discountMarks;
    }
}

