/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.IFillBackgroundColors;
import org.eclipse.nebula.widgets.ganttchart.IGanttChartItem;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GanttSection
implements IFillBackgroundColors {
    private String _name;
    private GanttComposite _parent;
    private List _ganttEvents = new ArrayList();
    private List _dndGanttEvents = new ArrayList();
    private Rectangle _bounds;
    private Image _nameImage;
    private boolean _needsNameUpdate;
    private IFillBackgroundColors _fillColorManager;
    private Color _saturdayBgColorTop;
    private Color _saturdayBgColorBottom;
    private Color _sundayBgColorTop;
    private Color _sundayBgColorBottom;
    private Color _weekdayBgColorTop;
    private Color _weekdayBgColorBottom;
    private Color _selectedBgColorTop;
    private Color _selectedBgColorBottom;
    private Color _selectedBgHeaderColorTop;
    private Color _selectedBgHeaderColorBottom;
    private Point _nameExtent;
    private int _textOrientation = 512;
    private boolean _inheritBackgroud;

    private GanttSection() {
    }

    public GanttSection(GanttChart parent, String name) {
        this();
        this._name = name;
        this._parent = parent.getGanttComposite();
        this._parent.addSection(this);
        this._fillColorManager = parent.getColorManager();
    }

    public GanttSection(GanttChart parent, String name, IFillBackgroundColors fillManager) {
        this();
        this._name = name;
        this._parent = parent.getGanttComposite();
        this._parent.addSection(this);
        this._fillColorManager = fillManager;
    }

    public void addGanttEvent(IGanttChartItem event) {
        this.addGanttEvent(-1, event);
    }

    public void addGanttEvent(int index, IGanttChartItem event) {
        int inx = index;
        if (!this._ganttEvents.contains(event)) {
            if (inx == -1) {
                this._ganttEvents.add(event);
            } else {
                if (inx > this._ganttEvents.size()) {
                    inx = this._ganttEvents.size();
                }
                this._ganttEvents.add(inx, event);
            }
            if (event instanceof GanttEvent) {
                ((GanttEvent)event).setGanttSection(this);
            }
        }
    }

    public void removeGanttEvent(IGanttChartItem event) {
        this._ganttEvents.remove(event);
    }

    public List getEvents() {
        return this._ganttEvents;
    }

    public void setName(String name) {
        this._name = name;
        this._needsNameUpdate = true;
    }

    public String getName() {
        return this._name;
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public Color getSaturdayBackgroundColorBottom() {
        return this._saturdayBgColorBottom == null ? this._fillColorManager.getSaturdayBackgroundColorBottom() : this._saturdayBgColorBottom;
    }

    public Color getSaturdayBackgroundColorTop() {
        return this._saturdayBgColorTop == null ? this._fillColorManager.getSaturdayBackgroundColorTop() : this._saturdayBgColorTop;
    }

    public Color getSundayBackgroundColorBottom() {
        return this._sundayBgColorBottom == null ? this._fillColorManager.getSundayBackgroundColorBottom() : this._sundayBgColorBottom;
    }

    public Color getSundayBackgroundColorTop() {
        return this._sundayBgColorTop == null ? this._fillColorManager.getSundayBackgroundColorTop() : this._sundayBgColorTop;
    }

    public Color getWeekdayBackgroundColorBottom() {
        return this._weekdayBgColorBottom == null ? this._fillColorManager.getWeekdayBackgroundColorBottom() : this._weekdayBgColorBottom;
    }

    public Color getWeekdayBackgroundColorTop() {
        return this._weekdayBgColorTop == null ? this._fillColorManager.getWeekdayBackgroundColorTop() : this._weekdayBgColorTop;
    }

    public Color getSelectedDayColorBottom() {
        return this._selectedBgColorBottom == null ? this._fillColorManager.getSelectedDayColorBottom() : this._selectedBgColorBottom;
    }

    public Color getSelectedDayColorTop() {
        return this._selectedBgColorTop == null ? this._fillColorManager.getSelectedDayColorTop() : this._selectedBgColorTop;
    }

    public Color getSelectedDayHeaderColorBottom() {
        return this._selectedBgHeaderColorBottom == null ? this._fillColorManager.getSelectedDayHeaderColorBottom() : this._selectedBgHeaderColorBottom;
    }

    public Color getSelectedDayHeaderColorTop() {
        return this._selectedBgHeaderColorTop == null ? this._fillColorManager.getSelectedDayHeaderColorTop() : this._selectedBgHeaderColorTop;
    }

    public void setSaturdayBackgroundColorTop(Color saturdayBackgroundColorTop) {
        this._saturdayBgColorTop = saturdayBackgroundColorTop;
    }

    public void setSaturdayBackgroundColorBottom(Color saturdayBackgroundColorBottom) {
        this._saturdayBgColorBottom = saturdayBackgroundColorBottom;
    }

    public void setSundayBackgroundColorTop(Color sundayBackgroundColorTop) {
        this._sundayBgColorTop = sundayBackgroundColorTop;
    }

    public void setSundayBackgroundColorBottom(Color sundayBackgroundColorBottom) {
        this._sundayBgColorBottom = sundayBackgroundColorBottom;
    }

    public void setWeekdayBackgroundColorTop(Color weekdayBackgroundColorTop) {
        this._weekdayBgColorTop = weekdayBackgroundColorTop;
    }

    public void setWeekdayBackgroundColorBottom(Color weekdayBackgroundColorBottom) {
        this._weekdayBgColorBottom = weekdayBackgroundColorBottom;
    }

    public void setSelectedBackgroundColorTop(Color selectedBackgroundColorTop) {
        this._selectedBgColorTop = selectedBackgroundColorTop;
    }

    public void setSelectedBackgroundColorBottom(Color selectedBackgroundColorBottom) {
        this._selectedBgColorBottom = selectedBackgroundColorBottom;
    }

    public void setSelectedBackgroundHeaderColorTop(Color selectedBackgroundHeaderColorTop) {
        this._selectedBgHeaderColorTop = selectedBackgroundHeaderColorTop;
    }

    public void setSelectedBackgroundHeaderColorBottom(Color selectedBackgroundHeaderColorBottom) {
        this._selectedBgHeaderColorBottom = selectedBackgroundHeaderColorBottom;
    }

    public int getTextOrientation() {
        return this._textOrientation;
    }

    public void setTextOrientation(int textOrientation) {
        this._textOrientation = textOrientation;
    }

    boolean isInheritBackgroud() {
        return this._inheritBackgroud;
    }

    void setInheritBackgroud(boolean inheritBackgroud) {
        this._inheritBackgroud = inheritBackgroud;
    }

    public void dispose() {
        this._parent.removeSection(this);
        this._parent.redraw();
    }

    Point getNameExtent() {
        return this._nameExtent;
    }

    void setNameExtent(Point extent) {
        this._nameExtent = extent;
    }

    void setBounds(Rectangle bounds) {
        this._bounds = bounds;
    }

    Image getNameImage() {
        return this._nameImage;
    }

    void setNameImage(Image nameImage) {
        this._nameImage = nameImage;
        this._needsNameUpdate = false;
    }

    boolean needsNameUpdate() {
        return this._needsNameUpdate;
    }

    void setNeedsNameUpdate(boolean need) {
        this._needsNameUpdate = need;
    }

    int getEventsHeight(ISettings settings) {
        if (this._ganttEvents.size() == 0) {
            return settings.getMinimumSectionHeight();
        }
        int height = settings.getEventsTopSpacer();
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            IGanttChartItem event = (IGanttChartItem)this._ganttEvents.get(i);
            height = event.isAutomaticRowHeight() ? (height += settings.getEventHeight()) : (height += event.getFixedRowHeight());
            if (i == this._ganttEvents.size() - 1) continue;
            height += settings.getEventSpacer();
        }
        if ((height += settings.getEventsBottomSpacer()) < settings.getMinimumSectionHeight()) {
            height = settings.getMinimumSectionHeight();
        }
        return height;
    }

    void addDNDGanttEvent(GanttEvent ge) {
        if (!this._dndGanttEvents.contains(ge)) {
            this._dndGanttEvents.add(ge);
        }
    }

    void clearDNDGanttEvents() {
        this._dndGanttEvents.clear();
    }

    List getDNDGanttEvents() {
        return this._dndGanttEvents;
    }

    public String toString() {
        return "[GanttSection: " + this._name + "]";
    }
}

