/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventCatalog;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.provider.IOrderedContentProvider;

public class TmccatalogContentProvider
implements IStructuredContentProvider,
IOrderedContentProvider {
    private final Map<InventCatalog, String> map = new HashMap<InventCatalog, String>();
    private boolean ascending = true;
    private String sortBy;
    private final TableViewer tableViewer;

    public TmccatalogContentProvider(Invent model, TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.sortBy = "catalogcode";
        if (model.getCode() != null) {
            InventCatalog state = (InventCatalog)LibActivator.getDefault().getActualClassResolver().getInstance(InventCatalog.class);
            state.setTmccode(model.getCode());
            List objects = ModelActivator.getDefault().getModelProvider().getDirectoryModel(InventCatalog.class).getList(this.sortBy, this.ascending, (Object)state);
            for (InventCatalog object : objects) {
                this.map.put(object, DirectoryAction.NONE.toString());
            }
        }
    }

    public Map<InventCatalog, String> getMap() {
        return this.map;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<InventCatalog> tmccatalogs = new ArrayList<InventCatalog>();
        for (InventCatalog key : this.map.keySet()) {
            if (this.map.get(key).equals(DirectoryAction.REMOVE.toString())) continue;
            tmccatalogs.add(key);
        }
        Collections.sort(tmccatalogs, new Comparator<InventCatalog>(){

            @Override
            public int compare(InventCatalog o1, InventCatalog o2) {
                int result = 0;
                if (o1.getCatalog() != null && o2.getCatalog() != null) {
                    if (TmccatalogContentProvider.this.sortBy.equals("catalogcode")) {
                        result = o1.getCatalog().getCatalogid().compareTo(o2.getCatalog().getCatalogid());
                    } else if (TmccatalogContentProvider.this.sortBy.equals("catalogs")) {
                        result = o1.getCatalog().getCatalogname().compareTo(o2.getCatalog().getCatalogname());
                    }
                }
                return TmccatalogContentProvider.this.ascending ? result : result * -1;
            }
        });
        return tmccatalogs.toArray();
    }

    public String getSortProperty() {
        return this.sortBy;
    }

    public void setSortProperty(String sortby) {
        this.sortBy = sortby;
        this.tableViewer.setInput(null);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

