/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanagercore.converter;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.accounting.domain.AdditionalAssetInfo;
import su.artix.accounting.domain.Asset;
import su.artix.accounting.domain.AssetGroup;
import su.artix.accounting.domain.AssetStatus;
import su.artix.accounting.domain.AssetTransactionStatus;
import su.artix.accounting.domain.Terminal;
import su.artix.accounting.rpc.logic.thriftapi.TransactionStatus;

public class AssetConverter {
    private static final Logger log = LoggerFactory.getLogger(AssetConverter.class);

    public Asset convert(su.artix.accounting.rpc.logic.thriftapi.Asset assetThrift) {
        Asset assetInner = new Asset();
        try {
            assetInner.setAmount(assetThrift.getAmount());
            assetInner.setSessionId(assetThrift.getId());
            assetInner.setSessionId(assetThrift.getId());
            assetInner.setStatus(AssetStatus.findByValue((int)assetThrift.getStatus()));
            Terminal terminalInner = null;
            if (assetThrift.getTransactionStatuses() != null) {
                for (TransactionStatus transactionStatus : assetThrift.getTransactionStatuses()) {
                    assetInner.addAssetTrasactionStatus(AssetConverter.convert(transactionStatus));
                }
            }
            AssetTransactionStatus lastStatusInner = null;
            if (assetThrift.getLastStatus() != null && assetThrift.getTransactionStatuses() == null) {
                lastStatusInner = AssetConverter.convert(assetThrift.getLastStatus());
                assetInner.setLastStatus(lastStatusInner.getTransactionStatus());
                assetInner.addAssetTrasactionStatus(lastStatusInner);
            }
            if (assetThrift.getAdditionalInfo() != null) {
                AdditionalAssetInfo additionalAssetInfo = new AdditionalAssetInfo();
                if (assetThrift.getAdditionalInfo().getDateFromCash() != 0L) {
                    additionalAssetInfo.setDateFromCash(new Date(assetThrift.getAdditionalInfo().getDateFromCash()));
                }
                if (lastStatusInner != null) {
                    if (lastStatusInner.getTransactionReason() == null) {
                        lastStatusInner.setTransactionReason(assetThrift.getAdditionalInfo().getReason());
                    }
                    if (lastStatusInner.getTransactionSource() == null) {
                        lastStatusInner.setTransactionSource(assetThrift.getAdditionalInfo().getSource());
                    }
                }
                assetInner.setAdditionalInfo(additionalAssetInfo);
            }
            if (assetThrift.getAssetGroup() != null) {
                AssetGroup assetGroup = new AssetGroup();
                assetGroup.setGroupId(assetThrift.getAssetGroup().getGroupId());
                assetGroup.setWeight(Integer.valueOf(assetThrift.getAssetGroup().getWeight()));
                long beginTime = assetThrift.getAssetGroup().getBeginDate();
                assetGroup.setBegin(beginTime == 0L ? null : new Date(beginTime));
                long endTime = assetThrift.getAssetGroup().getEndDate();
                assetGroup.setEnd(endTime == 0L ? null : new Date(endTime));
                assetInner.setAssetGroup(assetGroup);
            }
            assetInner.setDate(new Date(assetThrift.getTime()));
            terminalInner = new Terminal();
            terminalInner.setTerminalId(assetThrift.getTerminal().getId());
            terminalInner.setBlocked(assetThrift.getTerminal().isBlocked());
            assetInner.setTerminal(terminalInner);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return assetInner;
    }

    private static AssetTransactionStatus convert(TransactionStatus status) {
        AssetTransactionStatus statusInner = new AssetTransactionStatus();
        statusInner.setDate(new Date(status.getDate()));
        Terminal terminalInner = new Terminal();
        if (status.getTerminal() != null) {
            terminalInner.setBlocked(status.getTerminal().isBlocked());
            terminalInner.setTerminalId(status.getTerminal().getId());
        }
        statusInner.setTerminal(terminalInner);
        statusInner.setTransactionReason(status.getReason());
        statusInner.setTransactionSource(status.getSource());
        statusInner.setTransactionStatus(su.artix.accounting.domain.TransactionStatus.findByValue((int)status.getStatus()));
        return statusInner;
    }

    public AssetGroup convert(su.artix.accounting.rpc.logic.thriftapi.AssetGroup assetGroupThrift) {
        AssetGroup assetGroupInner = new AssetGroup();
        assetGroupInner.setGroupId(assetGroupThrift.getGroupId());
        assetGroupInner.setWeight(Integer.valueOf(assetGroupThrift.getWeight()));
        assetGroupInner.setBegin(assetGroupThrift.getBeginDate() == 0L ? null : new Date(assetGroupThrift.getBeginDate()));
        assetGroupInner.setEnd(assetGroupThrift.getEndDate() == 0L ? null : new Date(assetGroupThrift.getEndDate()));
        return assetGroupInner;
    }

    public su.artix.accounting.rpc.logic.thriftapi.AssetGroup convert(AssetGroup assetGroup) {
        su.artix.accounting.rpc.logic.thriftapi.AssetGroup assetGroupThrift = new su.artix.accounting.rpc.logic.thriftapi.AssetGroup();
        assetGroupThrift.setGroupId(assetGroup.getGroupId());
        assetGroupThrift.setWeight(assetGroup.getWeight() == null ? 0 : assetGroup.getWeight());
        assetGroupThrift.setBeginDate(assetGroup.getBegin() == null ? 0L : assetGroup.getBegin().getTime());
        assetGroupThrift.setEndDate(assetGroup.getEnd() == null ? 0L : assetGroup.getEnd().getTime());
        return assetGroupThrift;
    }
}

