/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTWidget;
import org.mihalis.opal.propertyTable.PTWidgetFactory;
import org.mihalis.opal.propertyTable.PropertyTable;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;
import org.mihalis.opal.utils.StringUtil;

public abstract class AbstractPTWidget
implements PTWidget {
    private PropertyTable parentPropertyTable;
    protected StyledText descriptionLabel;

    @Override
    public abstract void refillData();

    protected abstract void buildWidget(Composite var1);

    @Override
    public PTWidget build() {
        PropertyTable propertyTable;
        SashForm sashForm = null;
        if (this.parentPropertyTable.showDescription) {
            sashForm = new SashForm((Composite)this.parentPropertyTable, 2560);
            sashForm.setSashWidth(3);
            sashForm.setLayout((Layout)new GridLayout());
            propertyTable = new Composite((Composite)sashForm, 0);
            propertyTable.setLayoutData(new GridData(4, 4, true, true));
        } else {
            propertyTable = this.parentPropertyTable;
        }
        propertyTable.setLayout((Layout)new GridLayout(3, false));
        if (this.parentPropertyTable.showButtons) {
            this.buildButtons(propertyTable, this.parentPropertyTable.sorted, this.parentPropertyTable.styleOfView == 1, this.parentPropertyTable.showDescription);
        }
        this.buildWidget(propertyTable);
        if (this.parentPropertyTable.showDescription) {
            this.buildDescriptionPanel((Composite)sashForm);
            sashForm.setWeights(new int[]{90, 10});
        }
        return this;
    }

    private void buildButtons(Composite composite, boolean bl, boolean bl2, boolean bl3) {
        this.buildSortButton(composite, bl);
        this.buildCategoryButton(composite, bl2);
        this.buildDescriptionButton(composite, bl3);
    }

    private void buildSortButton(Composite composite, boolean bl) {
        Button button = new Button(composite, 0x800002);
        button.setImage(new Image((Device)composite.getDisplay(), this.getClass().getClassLoader().getResourceAsStream("images/sort.png")));
        button.setSelection(bl);
        button.setToolTipText(ResourceManager.getLabel("sort.shortDescription"));
        button.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractPTWidget.this.getParentPropertyTable().sorted = !AbstractPTWidget.this.getParentPropertyTable().sorted;
                AbstractPTWidget.this.refillData();
            }
        });
    }

    private void buildCategoryButton(Composite composite, boolean bl) {
        Button button = new Button(composite, 0x800002);
        button.setImage(new Image((Device)composite.getDisplay(), this.getClass().getClassLoader().getResourceAsStream("images/category.png")));
        button.setSelection(bl);
        button.setToolTipText(ResourceManager.getLabel("category.shortDescription"));
        button.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AbstractPTWidget.this.getParentPropertyTable().styleOfView == 1) {
                    AbstractPTWidget.this.getParentPropertyTable().viewAsFlatList();
                } else {
                    AbstractPTWidget.this.getParentPropertyTable().viewAsCategories();
                }
            }
        });
    }

    private void buildDescriptionButton(Composite composite, boolean bl) {
        Button button = new Button(composite, 0x800002);
        button.setImage(new Image((Device)composite.getDisplay(), this.getClass().getClassLoader().getResourceAsStream("images/description.png")));
        button.setSelection(bl);
        button.setToolTipText(ResourceManager.getLabel("description.shortDescription"));
        button.setLayoutData((Object)new GridData(1, 4, true, false, 1, 1));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AbstractPTWidget.this.getParentPropertyTable().showDescription) {
                    AbstractPTWidget.this.getParentPropertyTable().hideDescription();
                } else {
                    AbstractPTWidget.this.getParentPropertyTable().showDescription();
                }
            }
        });
    }

    private void buildDescriptionPanel(Composite composite) {
        this.descriptionLabel = new StyledText(composite, 8);
        this.descriptionLabel.setText("");
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    @Override
    public PTWidget disposeAndBuild(PropertyTable propertyTable) {
        this.dispose();
        return PTWidgetFactory.build(propertyTable);
    }

    private void dispose() {
        if (this.parentPropertyTable == null || this.parentPropertyTable.getChildren() == null) {
            return;
        }
        for (Control control : this.parentPropertyTable.getChildren()) {
            control.dispose();
        }
    }

    protected PropertyTable getParentPropertyTable() {
        return this.parentPropertyTable;
    }

    @Override
    public void setParentPropertyTable(PropertyTable propertyTable) {
        this.parentPropertyTable = propertyTable;
    }

    @Override
    public void updateDescriptionPanel(Object object) {
        if (object == null || this.descriptionLabel == null) {
            return;
        }
        PTProperty pTProperty = (PTProperty)object;
        this.descriptionLabel.setText(StringUtil.safeToString(pTProperty.getDescription()));
        SWTGraphicUtil.applyHTMLFormating(this.descriptionLabel);
        this.descriptionLabel.update();
    }
}

