/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTPropertyChangeListener;
import org.mihalis.opal.propertyTable.PTWidget;
import org.mihalis.opal.propertyTable.PTWidgetFactory;

public class PropertyTable
extends Composite {
    static final int VIEW_AS_FLAT_LIST = 0;
    static final int VIEW_AS_CATEGORIES = 1;
    boolean showButtons;
    boolean showDescription;
    boolean sorted;
    int styleOfView;
    final List<PTProperty> properties;
    private boolean hasBeenBuilt = false;
    private final List<PTPropertyChangeListener> changeListeners;
    private PTWidget widget;

    public PropertyTable(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new FillLayout(512));
        this.showButtons = true;
        this.showDescription = true;
        this.sorted = true;
        this.styleOfView = 1;
        this.properties = new ArrayList<PTProperty>();
        this.changeListeners = new ArrayList<PTPropertyChangeListener>();
        this.widget = PTWidgetFactory.build(this);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (!PropertyTable.this.hasBeenBuilt) {
                    PropertyTable.this.widget.build();
                    PropertyTable.this.hasBeenBuilt = true;
                }
            }
        });
    }

    public void addChangeListener(PTPropertyChangeListener pTPropertyChangeListener) {
        this.changeListeners.add(pTPropertyChangeListener);
    }

    public PTProperty addProperty(PTProperty pTProperty) {
        if (this.properties.contains(pTProperty)) {
            throw new IllegalArgumentException("A property called '" + pTProperty.getName() + "' has already been declared.");
        }
        this.properties.add(pTProperty);
        pTProperty.setParentTable(this);
        return pTProperty;
    }

    public void firePTPropertyChangeListeners(PTProperty pTProperty) {
        for (PTPropertyChangeListener pTPropertyChangeListener : this.changeListeners) {
            pTPropertyChangeListener.propertyHasChanged(pTProperty);
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (PTProperty pTProperty : this.properties) {
            hashMap.put(pTProperty.getName(), pTProperty.getValue());
        }
        return hashMap;
    }

    public List<PTProperty> getPropertiesAsList() {
        return new ArrayList<PTProperty>(this.properties);
    }

    public PropertyTable hideButtons() {
        this.showButtons = false;
        return this.rebuild();
    }

    public PropertyTable hideDescription() {
        this.showDescription = false;
        return this.rebuild();
    }

    private PropertyTable rebuild() {
        this.widget = this.widget.disposeAndBuild(this);
        if (this.hasBeenBuilt) {
            this.setLayout((Layout)new FillLayout());
            this.widget.build();
            this.layout();
        }
        return this;
    }

    public void removeChangeListener(PTPropertyChangeListener pTPropertyChangeListener) {
        this.changeListeners.remove(pTPropertyChangeListener);
    }

    public PropertyTable showButtons() {
        this.showButtons = true;
        return this.rebuild();
    }

    public PropertyTable showDescription() {
        this.showDescription = true;
        return this.rebuild();
    }

    public PropertyTable sort() {
        this.sorted = true;
        this.widget.refillData();
        return this;
    }

    public PropertyTable unsort() {
        this.sorted = false;
        this.widget.refillData();
        return this;
    }

    public PropertyTable viewAsCategories() {
        this.styleOfView = 1;
        return this.rebuild();
    }

    public PropertyTable viewAsFlatList() {
        this.styleOfView = 0;
        return this.rebuild();
    }
}

