/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation;

import com.richclientgui.toolbox.validation.CComboContentAdapter;
import com.richclientgui.toolbox.validation.IFieldErrorMessageHandler;
import com.richclientgui.toolbox.validation.IQuickFixProvider;
import com.richclientgui.toolbox.validation.ValidatingField;
import com.richclientgui.toolbox.validation.converter.IContentsStringConverter;
import com.richclientgui.toolbox.validation.validator.IFieldValidator;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ValidationToolkit<T> {
    private static final int DEFAULT_DECORATOR_POSITION = 0x1020000;
    private static final int DEFAULT_DECORATOR_MARGIN_WIDTH = 1;
    private final IContentsStringConverter<T> stringConverter;
    private int decoratorPosition = 0x1020000;
    private int decoratorMarginWidth = 1;
    private boolean showDecorators = true;
    private IFieldErrorMessageHandler defaultErrorMessageHandler;

    public ValidationToolkit(IContentsStringConverter<T> stringConverter) {
        this(stringConverter, 0x1020000, 1, true);
    }

    public ValidationToolkit(IContentsStringConverter<T> stringConverter, int decoratorPosition, int decoratorMarginWidth, boolean showDecorators) {
        this.stringConverter = stringConverter;
        this.decoratorPosition = decoratorPosition;
        this.decoratorMarginWidth = decoratorMarginWidth;
        this.showDecorators = showDecorators;
    }

    public void setDefaultErrorMessageHandler(IFieldErrorMessageHandler defaultErrorMessageHandler) {
        this.defaultErrorMessageHandler = defaultErrorMessageHandler;
    }

    public IContentsStringConverter<T> getStringConverter() {
        return this.stringConverter;
    }

    protected ValidatingField<T> createValidatingTextField(Text text, IFieldValidator<T> fieldValidator, ControlDecoration controlDecoration, boolean isRequired) {
        ValidatingField<T> textField = new ValidatingField<T>((Control)text, fieldValidator, controlDecoration, (IControlContentAdapter)new TextContentAdapter(), this.stringConverter, isRequired);
        return textField;
    }

    public ValidatingField<T> createTextField(Composite parent, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue) {
        return this.createTextField(parent, fieldValidator, isRequired, initialValue, null, null);
    }

    public ValidatingField<T> createTextField(Composite parent, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider) {
        Text text = new Text(parent, 2048);
        return this.createTextField(fieldValidator, isRequired, initialValue, errorMessageHandler, quickFixProvider, text);
    }

    private ValidatingField<T> createTextField(IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider, Text text) {
        ControlDecoration controlDecoration = null;
        if (this.showDecorators) {
            controlDecoration = new ControlDecoration((Control)text, this.decoratorPosition);
            controlDecoration.setMarginWidth(this.decoratorMarginWidth);
        }
        ValidatingField<T> textField = this.createValidatingTextField(text, fieldValidator, controlDecoration, isRequired);
        if (errorMessageHandler != null) {
            textField.setErrorMessageHandler(errorMessageHandler);
        } else if (this.defaultErrorMessageHandler != null) {
            textField.setErrorMessageHandler(this.defaultErrorMessageHandler);
        }
        if (quickFixProvider != null) {
            textField.setQuickFixProvider(quickFixProvider);
        }
        textField.setContents(initialValue);
        return textField;
    }

    protected ValidatingField<T> createValidatingComboField(Combo combo, IFieldValidator<T> fieldValidator, ControlDecoration controlDecoration, boolean isRequired) {
        ValidatingField<T> comboField = new ValidatingField<T>((Control)combo, fieldValidator, controlDecoration, (IControlContentAdapter)new ComboContentAdapter(), this.stringConverter, isRequired);
        return comboField;
    }

    public ValidatingField<T> createComboField(Composite parent, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, T[] items) {
        return this.createComboField(parent, fieldValidator, isRequired, initialValue, null, null, items);
    }

    public ValidatingField<T> createComboField(Composite parent, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider, T[] items) {
        Combo combo = new Combo(parent, 2048);
        if (items != null) {
            this.setComboItems(combo, items);
        }
        return this.createComboField(fieldValidator, isRequired, initialValue, errorMessageHandler, quickFixProvider, combo);
    }

    private void setComboItems(Combo combo, T[] items) {
        String[] strItems = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strItems[i] = this.stringConverter.convertToString(items[i]);
            ++i;
        }
        combo.setItems(strItems);
    }

    private ValidatingField<T> createComboField(IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider, Combo combo) {
        ControlDecoration controlDecoration = null;
        if (this.showDecorators) {
            controlDecoration = new ControlDecoration((Control)combo, this.decoratorPosition);
            controlDecoration.setMarginWidth(this.decoratorMarginWidth);
        }
        ValidatingField<T> comboField = this.createValidatingComboField(combo, fieldValidator, controlDecoration, isRequired);
        if (errorMessageHandler != null) {
            comboField.setErrorMessageHandler(errorMessageHandler);
        } else if (this.defaultErrorMessageHandler != null) {
            comboField.setErrorMessageHandler(this.defaultErrorMessageHandler);
        }
        if (quickFixProvider != null) {
            comboField.setQuickFixProvider(quickFixProvider);
        }
        comboField.setContents(initialValue);
        return comboField;
    }

    protected ValidatingField<T> createValidatingCComboField(CCombo combo, IFieldValidator<T> fieldValidator, ControlDecoration controlDecoration, boolean isRequired) {
        ValidatingField<T> comboField = new ValidatingField<T>((Control)combo, fieldValidator, controlDecoration, new CComboContentAdapter(), this.stringConverter, isRequired);
        return comboField;
    }

    public ValidatingField<T> createCComboField(Composite parent, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, T[] items) {
        return this.createCComboField(parent, fieldValidator, isRequired, initialValue, null, null, items);
    }

    public ValidatingField<T> createCComboField(Composite parent, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider, T[] items) {
        CCombo combo = new CCombo(parent, 2048);
        if (items != null) {
            this.setCComboItems(combo, items);
        }
        return this.createCComboField(fieldValidator, isRequired, initialValue, errorMessageHandler, quickFixProvider, combo);
    }

    private void setCComboItems(CCombo combo, T[] items) {
        String[] strItems = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strItems[i] = this.stringConverter.convertToString(items[i]);
            ++i;
        }
        combo.setItems(strItems);
    }

    private ValidatingField<T> createCComboField(IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider, CCombo combo) {
        ControlDecoration controlDecoration = null;
        if (this.showDecorators) {
            controlDecoration = new ControlDecoration((Control)combo, this.decoratorPosition);
            controlDecoration.setMarginWidth(this.decoratorMarginWidth);
        }
        ValidatingField<T> comboField = this.createValidatingCComboField(combo, fieldValidator, controlDecoration, isRequired);
        if (errorMessageHandler != null) {
            comboField.setErrorMessageHandler(errorMessageHandler);
        } else if (this.defaultErrorMessageHandler != null) {
            comboField.setErrorMessageHandler(this.defaultErrorMessageHandler);
        }
        if (quickFixProvider != null) {
            comboField.setQuickFixProvider(quickFixProvider);
        }
        comboField.setContents(initialValue);
        return comboField;
    }

    public ValidatingField<T> createField(Control control, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue) {
        return this.createField(control, fieldValidator, isRequired, initialValue, null, null);
    }

    public ValidatingField<T> createField(Control control, IFieldValidator<T> fieldValidator, boolean isRequired, T initialValue, IFieldErrorMessageHandler errorMessageHandler, IQuickFixProvider<T> quickFixProvider) {
        if (control instanceof Text) {
            return this.createTextField(fieldValidator, isRequired, initialValue, errorMessageHandler, quickFixProvider, (Text)control);
        }
        if (control instanceof Combo) {
            return this.createComboField(fieldValidator, isRequired, initialValue, errorMessageHandler, quickFixProvider, (Combo)control);
        }
        if (control instanceof CCombo) {
            return this.createCComboField(fieldValidator, isRequired, initialValue, errorMessageHandler, quickFixProvider, (CCombo)control);
        }
        throw new IllegalArgumentException("Control must be an instance of Text, Combo or CCombo");
    }
}

