/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.cards;

import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Card;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.cards.MassChangeForCardDialog;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.InfoMessageFactory;
import su.artix.discountmanager.utils.MultiLineDialogOperations;
import su.artix.discountmanager.utils.MultiLineMessages;
import su.artix.yuki.action.SecurityActionImpl;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.model.directory.DirectoryModelFactory;

public class MassCardChangeAction
extends SecurityActionImpl<Card> {
    private static final Logger log = LoggerFactory.getLogger(MassCardChangeAction.class);

    public MassCardChangeAction() {
        super(Card.class, false);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/cards_mass.png");
    }

    public String getToolTipText() {
        return "\u041c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f";
    }

    public String getText() {
        return "\u041c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f";
    }

    public void run() {
        MassChangeForCardDialog dlg = new MassChangeForCardDialog();
        if (dlg.open() == 0) {
            Activator.getDefault().setLoadCursor(true);
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof StructuredSelection) {
                final StructuredSelection strucSelection = (StructuredSelection)selection;
                final AtomicBoolean abortCommand = new AtomicBoolean(false);
                MultiLineDialogOperations cardMessageOperations = new MultiLineDialogOperations(){

                    @Override
                    public void abortOperation() {
                        abortCommand.set(true);
                    }
                };
                final Map<String, Object> changedProperties = dlg.getMap();
                final MultiLineMessages messages = InfoMessageFactory.multiLineInfoMessage(cardMessageOperations);
                ArtixAdminContextHolder.getConnectionId();
                final String connectionId = ArtixAdminContextHolder.getConnectionId();
                Thread changeCardsThread = new Thread("CardChangedThread"){

                    @Override
                    public void run() {
                        ArtixAdminContextHolder.setConnectionId((String)connectionId);
                        boolean errorExist = false;
                        DirectoryEditModel directoryModel = DirectoryModelFactory.getModel(Card.class);
                        for (Card card : strucSelection) {
                            try {
                                if (abortCommand.get()) break;
                                for (String property : changedProperties.keySet()) {
                                    PropertyDescriptor pd = new PropertyDescriptor(property, card.getClass());
                                    pd.getWriteMethod().invoke((Object)card, changedProperties.get(property));
                                }
                                directoryModel.update((Object)card);
                                messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u2116: " + card.getNumber() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                errorExist = true;
                                messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + card.getNumber() + " \u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430: {}" + e.getMessage());
                            }
                        }
                        directoryModel.doRefresh();
                        messages.lastMessage(errorExist ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043e\u043a");
                    }
                };
                changeCardsThread.start();
                Activator.getDefault().setLoadCursor(false);
            }
        }
    }
}

