/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.keyboard.gui;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import su.artix.yuki.keyboard.domain.KeyboardContainer;

public class SelectKeyboardDialog
extends TitleAreaDialog {
    private List<KeyboardContainer> keyboards;
    private TableViewer tableViewer;
    private KeyboardContainer selectedKeyboard;

    public SelectKeyboardDialog(Shell parentShell, List<KeyboardContainer> keyboards) {
        super(parentShell);
        this.keyboards = keyboards;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u0412\u044b\u0431\u043e\u0440 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("\u0412\u044b\u0431\u043e\u0440 \u043c\u0430\u043a\u0435\u0442\u0430 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b");
        this.setMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0443, \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c");
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label selectLabel = new Label(main, 0);
        GridDataFactory.fillDefaults().applyTo((Control)selectLabel);
        selectLabel.setText("\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440: ");
        this.tableViewer = new TableViewer(main, 67584);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        this.addColumns(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectKeyboardDialog.this.okPressed();
            }
        });
        this.tableViewer.setInput(this.keyboards);
        return main;
    }

    private void addColumns(TableViewer viewer) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                KeyboardContainer keyboard = (KeyboardContainer)element;
                return keyboard.getName();
            }
        });
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setWidth(130);
        column.getColumn().setText("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043b\u0430\u0432\u0438\u0448");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                KeyboardContainer keyboard = (KeyboardContainer)element;
                return String.valueOf(keyboard.getButtons().size());
            }
        });
    }

    protected void okPressed() {
        Object selectedObj;
        StructuredSelection select = (StructuredSelection)this.tableViewer.getSelection();
        if (select != null && (selectedObj = select.getFirstElement()) instanceof KeyboardContainer) {
            this.selectedKeyboard = (KeyboardContainer)selectedObj;
        }
        super.okPressed();
    }

    public KeyboardContainer getKeyboard() {
        return this.selectedKeyboard;
    }
}

