/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.domain.Connect;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.connection.ManagedDataSource;
import su.artix.artixadmin.connection.ManagedHost;
import su.artix.artixadmin.connection.ManagedWebUserSource;
import su.artix.artixadmin.connection.manager.DataSourceFactory;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.discountmanager.Activator;
import su.artix.discountmanagercore.holders.ConnectionHolder;
import su.artix.yuki.model.ModelActivator;

public class CashConnector {
    private static final String DB_VERSION_CASH_QUERY = "select `version` from `migrate_version`";
    private static final String DB_VERSION_SERVER_QUERY = "select `version` from `migrate_version` where `repository_id`='artixcsAll' limit 1";
    private static final Logger log = LoggerFactory.getLogger(CashConnector.class);
    private static final CashConnector cashConnector = new CashConnector();
    private static final String dbName = "dictionaries";
    private static final String docDbName = "documents";
    private static final String All = "All";

    private void progressBarWork(final ProgressBar progressBar, final int work) {
        if (progressBar != null) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    progressBar.setSelection(progressBar.getSelection() + work);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getCSDictVersion(String storeId, DataSource dataSource) {
        block4: {
            version = 0;
            jdbcTemplate = new JdbcTemplate(dataSource);
            try {
                version = jdbcTemplate.queryForInt("select `version` from `migrate_version` where `repository_id`='artixcsAll' limit 1");
                break block4;
            }
            catch (BadSqlGrammarException v0) {
                CashConnector.log.info("couldn't detirmine version from table 'migrate_version'");
                dbVersionQueryes = new ArrayList<E>();
                Collections.addAll(dbVersionQueryes, new Serializable[]{"select count(*) from DATABASECHANGELOG where ID='43' and AUTHOR='adm' and FILENAME='su/artix/cashserver/changelog/db.changelog-2.0.1.xml'", Integer.valueOf(5), "select count(*) from DATABASECHANGELOG where ID='1' and AUTHOR='caa' and FILENAME='su/artix/cashserver/changelog/db.changelog-2.0.1.xml'", Integer.valueOf(10)});
                i = 0;
                ** while (i < dbVersionQueryes.size())
            }
lbl-1000:
            // 1 sources

            {
                rez = jdbcTemplate.queryForInt((String)dbVersionQueryes.get(i));
                if (rez != 0) {
                    version = (Integer)dbVersionQueryes.get(i + 1);
                }
                i += 2;
                continue;
            }
        }
        CashConnector.log.info("Cashserver database migration version: {}", (Object)version);
        return version;
    }

    private boolean simpleConnect(Connect currentConnect, WebUser webUser, ConnectionType connectionType, ProgressBar progressBar, boolean initSessionFactory) {
        DataSource dataSourceCategory;
        DataSource dataSourceDBAll;
        block11: {
            try {
                this.progressBarWork(progressBar, 10);
                if (initSessionFactory || Activator.getDefault().saveDiscountSystems()) break block11;
                return false;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)e.getMessage());
                return false;
            }
        }
        DataSourceFactory sourceFactory = ArtixAdminActivator.getDefault().getBeanByClass(DataSourceFactory.class);
        this.progressBarWork(progressBar, 10);
        String ip = currentConnect.isMysqlServerSplitConnect() ? currentConnect.getMysqlServerHost() : currentConnect.getAddress();
        String port = currentConnect.getPort();
        String prefix = currentConnect.getPrefix();
        String storeId = StringUtils.defaultString((String)currentConnect.getStoreId());
        String clusterId = StringUtils.defaultString((String)currentConnect.getClusterId());
        String rcpPort = currentConnect.getRcpPort();
        String user = currentConnect.isMysqlServerSplitConnect() ? currentConnect.getMysqlServerLogin() : currentConnect.getLogin();
        String password = currentConnect.isMysqlServerSplitConnect() ? currentConnect.getMysqlServerPassword() : currentConnect.getPassword();
        DataSource dataSource = sourceFactory.makeDataSource(user, password, ip, port, String.valueOf(clusterId) + dbName + storeId);
        DataSource documentsDataSource = sourceFactory.makeDataSource(user, password, ip, port, String.valueOf(clusterId) + docDbName + this.getSaleStoreId(connectionType, storeId), true);
        if (connectionType == ConnectionType.CASH) {
            dataSourceDBAll = dataSource;
            dataSourceCategory = dataSource;
        } else {
            dataSourceDBAll = sourceFactory.makeDataSource(user, password, ip, port, String.valueOf(clusterId) + dbName + All);
            String defaultCategory = System.getProperty("yuki.discount_default_store");
            dataSourceCategory = StringUtils.isNotEmpty((String)defaultCategory) ? sourceFactory.makeDataSource(user, password, ip, port, String.valueOf(clusterId) + dbName + defaultCategory) : null;
        }
        String id = String.valueOf(ip) + port + clusterId + prefix + storeId + webUser.getName();
        ArtixAdminActivator.getDefault().getBeanByClass(ManagedDataSource.class, "dataSource").put((Object)id, dataSource);
        ArtixAdminActivator.getDefault().getBeanByClass(ManagedDataSource.class, "documentsDataSource").put((Object)id, documentsDataSource);
        ArtixAdminActivator.getDefault().getBeanByClass(ManagedDataSource.class, "dataSourceDBAll").put((Object)id, dataSourceDBAll);
        if (dataSourceCategory != null) {
            ArtixAdminActivator.getDefault().getBeanByClass(ManagedDataSource.class, "dataSourceCategory").put((Object)id, dataSourceCategory);
        }
        ArtixAdminActivator.getDefault().getBeanByClass(ManagedHost.class, "httpInvokerHost").put((Object)id, currentConnect.getAddress(), rcpPort);
        ArtixAdminActivator.getDefault().getBeanByClass(ManagedWebUserSource.class, "webUserSource").put((Object)id, webUser);
        ArtixAdminContextHolder.setConnectionId((String)id);
        ArtixAdminContextHolder.setUserName((String)webUser.getName());
        if (connectionType == ConnectionType.CASH) {
            JdbcTemplate template = new JdbcTemplate(dataSource);
            Integer dicVersion = template.queryForInt(DB_VERSION_CASH_QUERY);
            JdbcTemplate templateDoc = new JdbcTemplate(documentsDataSource);
            Integer docVersion = templateDoc.queryForInt(DB_VERSION_CASH_QUERY);
            this.initSessionFactory(webUser, progressBar, dicVersion, docVersion);
            ArtixAdminContextHolder.setHibernateSessionInited((boolean)true);
        } else {
            DataSource ds = sourceFactory.makeDataSource(user, password, ip, port, String.valueOf(clusterId) + "artixcs" + storeId);
            if (initSessionFactory) {
                Integer dicVersion;
                Integer docVersion = dicVersion = Integer.valueOf(this.getCSDictVersion(storeId, ds));
                this.initSessionFactory(webUser, progressBar, dicVersion, docVersion);
                ArtixAdminContextHolder.setHibernateSessionInited((boolean)true);
            }
            sourceFactory.resetDataSourceConnections(ds);
        }
        LibActivator.getDefault().clearModels();
        this.progressBarWork(progressBar, 5);
        DaoFactory.clearModels();
        ConnectionHolder.setStoreId((String)storeId);
        Activator.getDefault().refrashModels();
        ModelActivator.getDefault().getModelProvider().refreshAllModels();
        ArtixAdminActivator.getDefault().setCurrentConnect(currentConnect);
        if (connectionType.equals((Object)ConnectionType.SERVER)) {
            ArtixAdminActivator.getDefault().setCashServer(true);
            ConnectionHolder.setCash((boolean)false);
        } else {
            ArtixAdminActivator.getDefault().setCashServer(false);
            ConnectionHolder.setCash((boolean)true);
        }
        return true;
    }

    private boolean isGlobalSale() {
        return ArtixAdminActivator.getDefault().isGlobalSale();
    }

    private String getSaleStoreId(ConnectionType connectionType, String storeId) {
        if (connectionType == ConnectionType.SERVER && this.isGlobalSale()) {
            return All;
        }
        return storeId;
    }

    protected void initSessionFactory(WebUser webUser, ProgressBar progressBar, Integer dicVersion, Integer docVersion) {
        long point = System.currentTimeMillis();
        this.progressBarWork(progressBar, 10);
        LibActivator.getDefault().initializeDictionary(webUser.getName(), dicVersion);
        this.progressBarWork(progressBar, 20);
        LibActivator.getDefault().initializeDocument(webUser.getName(), docVersion);
        this.progressBarWork(progressBar, 10);
        LibActivator.getDefault().initializeDictionaryAll(webUser.getName(), dicVersion);
        LibActivator.getDefault().initializeDictionaryCategory(webUser.getName(), dicVersion);
        log.info("initialize factory={}", (Object)(System.currentTimeMillis() - point));
    }

    public static CashConnector getInstance() {
        return cashConnector;
    }

    public Boolean connectToCash(Connect currentConnect, WebUser webUser, ProgressBar progressBar) {
        return this.simpleConnect(currentConnect, webUser, ConnectionType.CASH, progressBar, true);
    }

    public Boolean connectToCashserver(Connect currentConnect, WebUser webUser, ProgressBar progressBar, boolean initSessionFactory) {
        return this.simpleConnect(currentConnect, webUser, ConnectionType.SERVER, progressBar, initSessionFactory);
    }

    private static enum ConnectionType {
        CASH,
        SERVER;

    }
}

