/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.connect;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContextHolder;
import ru.ssa.artixadmin.CashConnector;
import ru.ssa.artixadmin.action.connect.TestConnectAction;
import ru.ssa.artixadmin.editors.connect.UserConnectDialog;
import ru.ssa.artixadmin.editors.connect.UserConnecting;
import ru.ssa.cashadmin.domain.CSVersion;
import ru.ssa.cashadmin.domain.Connect;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.discountmanagercore.holders.PropertiesHolder;

public class ConnectAction {
    private static final Logger log = LoggerFactory.getLogger(ConnectAction.class);
    private final Connect connect;
    private final boolean cashserver;
    private ProgressBar progressBar;

    public ConnectAction(Connect connect, boolean cashserver, ProgressBar progressBar) {
        this.connect = connect;
        this.cashserver = cashserver;
        this.progressBar = progressBar;
    }

    public boolean run() {
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Display display = Display.getCurrent();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    display.getActiveShell().setCursor(new Cursor((Device)display, 1));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        });
        boolean succefull = this.cashserver ? this.connectToServer() : this.connectToCash();
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Display.getCurrent().getActiveShell().setCursor(new Cursor((Device)Display.getCurrent(), 0));
                }
                catch (RuntimeException e) {
                    log.error(e.getMessage());
                }
            }
        });
        return succefull;
    }

    private boolean connectToServer() {
        boolean succefull;
        WebUser webUser = new WebUser();
        webUser = this.auth(this.connect);
        if (webUser != null) {
            if (!this.connect.getCsVersion().older(CSVersion.VERSION2_3)) {
                if (webUser.getBasePrefix() == null && webUser.getMysqlLogin() == null && webUser.getMysqlPassword() == null) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u041a\u0421!", (String)"\u041a\u0421 \u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0443\u044e \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e.\n\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 \u043c\u043b\u0430\u0434\u0448\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u041a\u0421 (\u043d\u0438\u0436\u0435 2.3)");
                    succefull = false;
                } else {
                    this.connect.setPrefix(webUser.getBasePrefix());
                    this.connect.setLogin(webUser.getMysqlLogin());
                    this.connect.setPassword(webUser.getMysqlPassword());
                    succefull = true;
                }
            } else {
                succefull = true;
            }
            if (succefull && (succefull = this.testConnection())) {
                String shopId = "All";
                this.connect.setStoreId(shopId);
                this.connect.setClusterId(webUser.getClusterId());
                ArrayList<GrantedAuthorityImpl> AUTHORITIES = new ArrayList<GrantedAuthorityImpl>();
                if (webUser.getSecurityRoles() != null) {
                    for (SecurityRole role : webUser.getSecurityRoles()) {
                        if (role == null) continue;
                        AUTHORITIES.add(new GrantedAuthorityImpl(role.getRoleName()));
                    }
                }
                UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)webUser.getName(), (Object)webUser.getPassword(), AUTHORITIES);
                SecurityContextHolder.getContext().setAuthentication((Authentication)result);
                succefull = CashConnector.getInstance().connectToCashserver(this.connect, webUser, this.progressBar, true);
                if (this.connect.isBonusServerConnect()) {
                    PropertiesHolder.INSTANCE.setAccountingProperty("logic.server.admin.location", String.format("%s:%s", this.connect.getAccAddress(), this.connect.getAccAdminPort()));
                    PropertiesHolder.INSTANCE.setAccountingProperty("logic.server.base.location", String.format("%s:%s", this.connect.getAccAddress(), this.connect.getAccLogicPort()));
                    PropertiesHolder.INSTANCE.setAccountingProperty("terminal.id", this.connect.getAccTerminalId());
                    PropertiesHolder.INSTANCE.setAccountingProperty("source", this.createSourceForAccounting(webUser));
                }
            }
        } else {
            succefull = false;
        }
        return succefull;
    }

    private String createSourceForAccounting(WebUser webUser) {
        if (StringUtils.isEmpty((String)webUser.getDeptCode())) {
            return webUser.getName();
        }
        return String.valueOf(webUser.getDeptCode()) + "_" + webUser.getName();
    }

    private boolean connectToCash() {
        WebUser webUser = new WebUser();
        webUser = this.auth(this.connect);
        boolean succefull = false;
        if (webUser != null) {
            String id = String.valueOf(this.connect.getAddress()) + this.connect.getPort() + this.connect.getStoreId() + webUser.getName();
            ArtixAdminContextHolder.setConnectionId((String)id);
            ArrayList<GrantedAuthorityImpl> AUTHORITIES = new ArrayList<GrantedAuthorityImpl>();
            if (webUser.getSecurityRoles() != null) {
                for (SecurityRole role : webUser.getSecurityRoles()) {
                    if (role == null) continue;
                    AUTHORITIES.add(new GrantedAuthorityImpl(role.getRoleName()));
                }
            }
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)webUser.getName(), (Object)webUser.getPassword(), AUTHORITIES);
            SecurityContextHolder.getContext().setAuthentication((Authentication)result);
            succefull = CashConnector.getInstance().connectToCash(this.connect, webUser, this.progressBar);
        }
        return succefull;
    }

    private WebUser auth(Connect connect) {
        UserConnectDialog userConnectDialog;
        boolean silentAuth = Boolean.getBoolean("yuki.silent_auth_" + (this.cashserver ? "server" : "cash"));
        WebUser user = null;
        String authNameKey = "yuki.user";
        String passwordKey = "yuki.password";
        if (this.cashserver) {
            UserConnecting.initAuth(connect);
        } else {
            authNameKey = String.valueOf(authNameKey) + "_cash";
            passwordKey = String.valueOf(passwordKey) + "_cash";
        }
        if (silentAuth) {
            String authName = System.getProperty(authNameKey);
            String password = System.getProperty(passwordKey);
            if (authName != null && password != null) {
                user = UserConnecting.auth(authName, password);
            }
        }
        if (user == null && (userConnectDialog = new UserConnectDialog(this.cashserver)).open() == 0) {
            user = userConnectDialog.getWebUser();
        }
        return user;
    }

    private boolean testConnection() {
        TestConnectAction action = new TestConnectAction(this.connect, false, this.cashserver);
        action.run();
        return action.isSuccefull();
    }
}

