/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.docs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import ru.ssa.cashadmin.domain.docs.Workshift;

@Entity
@Table(name="cashierstats")
@MappedSuperclass
public class Cashierstats
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer cashierstatsid;
    @Column(name="workshiftid", insertable=false, updatable=false)
    private Integer workshiftid;
    @NotNull
    @ManyToOne
    @JoinColumn(name="workshiftid")
    @NotFound(action=NotFoundAction.IGNORE)
    private Workshift workshift;
    @Size(max=30)
    private String scode;
    @NotNull
    @Size(max=30)
    private String cashcode;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    private Date date_beg;
    @NotNull
    @Size(max=30)
    private String shopcode;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumsale;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumgain;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumsalecash;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumsalenoncash;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumsaleother;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumrefund;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumrefundcash;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumrefundnoncash;
    @NotNull
    private Integer countsale;
    @NotNull
    private Integer countrefund;
    @NotNull
    private Integer countstorno;
    @NotNull
    private Integer countdisc;
    @NotNull
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal sumstorno;
    @Min(value=0L)
    @Digits(integer=13, fraction=2)
    private BigDecimal timeaddposition;
    @NotNull
    private Integer countposition;

    protected Cashierstats() {
    }

    public Integer getCashierstatsid() {
        return this.cashierstatsid;
    }

    public void setCashierstatsid(Integer cashierstatsid) {
        this.cashierstatsid = cashierstatsid;
    }

    public Integer getWorkshiftid() {
        return this.workshiftid;
    }

    public void setWorkshiftid(Integer workshiftid) {
        this.workshiftid = workshiftid;
    }

    public Workshift getWorkshift() {
        return this.workshift;
    }

    public void setWorkshift(Workshift workshift) {
        this.workshift = workshift;
        this.workshiftid = workshift != null ? workshift.getWorkshiftid() : null;
    }

    public String getScode() {
        return this.scode;
    }

    public void setScode(String scode) {
        this.scode = scode;
    }

    public String getCashcode() {
        return this.cashcode;
    }

    public void setCashcode(String cashcode) {
        this.cashcode = cashcode;
    }

    public Date getDate_beg() {
        return this.date_beg;
    }

    public void setDate_beg(Date date_beg) {
        this.date_beg = date_beg;
    }

    public String getShopcode() {
        return this.shopcode;
    }

    public void setShopcode(String shopcode) {
        this.shopcode = shopcode;
    }

    public BigDecimal getSumsale() {
        return this.sumsale;
    }

    public void setSumsale(BigDecimal sumsale) {
        this.sumsale = sumsale;
    }

    public BigDecimal getSumgain() {
        return this.sumgain;
    }

    public void setSumgain(BigDecimal sumgain) {
        this.sumgain = sumgain;
    }

    public BigDecimal getSumsalecash() {
        return this.sumsalecash;
    }

    public void setSumsalecash(BigDecimal sumsalecash) {
        this.sumsalecash = sumsalecash;
    }

    public BigDecimal getSumsalenoncash() {
        return this.sumsalenoncash;
    }

    public void setSumsalenoncash(BigDecimal sumsalenoncash) {
        this.sumsalenoncash = sumsalenoncash;
    }

    public BigDecimal getSumsaleother() {
        return this.sumsaleother;
    }

    public void setSumsaleother(BigDecimal sumsaleother) {
        this.sumsaleother = sumsaleother;
    }

    public BigDecimal getSumrefund() {
        return this.sumrefund;
    }

    public void setSumrefund(BigDecimal sumrefund) {
        this.sumrefund = sumrefund;
    }

    public BigDecimal getSumrefundcash() {
        return this.sumrefundcash;
    }

    public void setSumrefundcash(BigDecimal sumrefundcash) {
        this.sumrefundcash = sumrefundcash;
    }

    public BigDecimal getSumrefundnoncash() {
        return this.sumrefundnoncash;
    }

    public void setSumrefundnoncash(BigDecimal sumrefundnoncash) {
        this.sumrefundnoncash = sumrefundnoncash;
    }

    public Integer getCountsale() {
        return this.countsale;
    }

    public void setCountsale(Integer countsale) {
        this.countsale = countsale;
    }

    public Integer getCountrefund() {
        return this.countrefund;
    }

    public void setCountrefund(Integer countrefund) {
        this.countrefund = countrefund;
    }

    public Integer getCountstorno() {
        return this.countstorno;
    }

    public void setCountstorno(Integer countstorno) {
        this.countstorno = countstorno;
    }

    public Integer getCountdisc() {
        return this.countdisc;
    }

    public void setCountdisc(Integer countdisc) {
        this.countdisc = countdisc;
    }

    public BigDecimal getSumstorno() {
        return this.sumstorno;
    }

    public void setSumstorno(BigDecimal sumstorno) {
        this.sumstorno = sumstorno;
    }

    public BigDecimal getTimeaddposition() {
        return this.timeaddposition;
    }

    public void setTimeaddposition(BigDecimal timeaddposition) {
        this.timeaddposition = timeaddposition;
    }

    public Integer getCountposition() {
        return this.countposition;
    }

    public void setCountposition(Integer countposition) {
        this.countposition = countposition;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cashierstatsid == null ? 0 : this.cashierstatsid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cashierstats)) {
            return false;
        }
        Cashierstats other = (Cashierstats)obj;
        return !(this.cashierstatsid == null ? other.cashierstatsid != null : !this.cashierstatsid.equals(other.cashierstatsid));
    }

    public String toString() {
        return "Cashierstats [cashierstatsid=" + this.cashierstatsid + ", workshiftid=" + this.workshiftid + ", workshift=" + this.workshift + ", scode=" + this.scode + ", cashcode=" + this.cashcode + ", date_beg=" + this.date_beg + ", shopcode=" + this.shopcode + ", sumsale=" + this.sumsale + ", sumgain=" + this.sumgain + ", sumsalecash=" + this.sumsalecash + ", sumsalenoncash=" + this.sumsalenoncash + ", sumsaleother=" + this.sumsaleother + ", sumrefund=" + this.sumrefund + ", sumrefundcash=" + this.sumrefundcash + ", sumrefundnoncash=" + this.sumrefundnoncash + ", countsale=" + this.countsale + ", countrefund=" + this.countrefund + ", countstorno=" + this.countstorno + ", countdisc=" + this.countdisc + ", sumstorno=" + this.sumstorno + ", timeaddposition=" + this.timeaddposition + ", countposition=" + this.countposition + "]";
    }
}

