/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.progressIndicator;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CoolProgressBar
extends Composite {
    private final Canvas rightBorder;
    private final Canvas fillRegion;
    private final Canvas emptyRegion;
    private final Canvas leftBorder;
    private final boolean horizontal;
    private final int recommendedWidth;
    private final int recommendedHeight;
    private int progressedPosition = 0;
    private double progressedPercentage = 0.0;

    public CoolProgressBar(Composite parent, int style, Image leftBorderImage, Image filledImage, Image emptyImage, Image rightBorderImage) {
        super(parent, 0x20000000);
        this.horizontal = 512 != (style & 0x200);
        this.setLayout((Layout)this.createLayout());
        this.recommendedWidth = leftBorderImage.getBounds().width;
        this.recommendedHeight = leftBorderImage.getBounds().height;
        this.leftBorder = this.createBorder(this, leftBorderImage);
        this.fillRegion = this.createFillRegion(this, this.horizontal ? filledImage : emptyImage);
        this.emptyRegion = this.createEmptyRegion(this, this.horizontal ? emptyImage : filledImage);
        this.rightBorder = this.createBorder(this, rightBorderImage);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CoolProgressBar.this.progressedPosition = (int)((double)CoolProgressBar.this.calculatePotentialFillExtent() * (CoolProgressBar.this.horizontal ? CoolProgressBar.this.progressedPercentage : 1.0 - CoolProgressBar.this.progressedPercentage));
                CoolProgressBar.this.fillRegion.setLayoutData((Object)CoolProgressBar.this.createFilledLayoutData());
                CoolProgressBar.this.layout();
            }
        });
    }

    private GridLayout createLayout() {
        GridLayout gl = new GridLayout(this.horizontal ? 4 : 1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        return gl;
    }

    private Canvas createBorder(Composite parent, Image image) {
        Canvas canvas = new Canvas(parent, 0);
        canvas.setBackgroundImage(image);
        GridData gd = new GridData(1, 1, false, false);
        gd.minimumHeight = this.recommendedHeight;
        gd.heightHint = this.recommendedHeight;
        gd.minimumWidth = this.recommendedWidth;
        gd.widthHint = this.recommendedWidth;
        canvas.setLayoutData((Object)gd);
        return canvas;
    }

    private Canvas createFillRegion(Composite parent, Image image) {
        Canvas canvas = new Canvas(parent, 0);
        canvas.setBackgroundImage(image);
        canvas.setLayoutData((Object)this.createFilledLayoutData());
        return canvas;
    }

    private GridData createFilledLayoutData() {
        GridData gd = new GridData(this.horizontal ? 1 : 4, this.horizontal ? 4 : 1, false, false);
        if (this.horizontal) {
            gd.minimumHeight = this.recommendedHeight;
            gd.heightHint = this.recommendedHeight;
            gd.widthHint = this.progressedPosition;
            gd.minimumWidth = this.progressedPosition;
        } else {
            gd.minimumWidth = this.recommendedWidth;
            gd.widthHint = this.recommendedWidth;
            gd.heightHint = this.progressedPosition;
            gd.minimumHeight = this.progressedPosition;
        }
        return gd;
    }

    private Canvas createEmptyRegion(Composite parent, Image image) {
        Canvas canvas = new Canvas(parent, 0);
        canvas.setBackgroundImage(image);
        GridData gd = new GridData(this.horizontal ? 4 : 4, this.horizontal ? 1 : 4, this.horizontal, !this.horizontal);
        if (this.horizontal) {
            gd.minimumHeight = this.recommendedHeight;
            gd.heightHint = this.recommendedHeight;
        } else {
            gd.minimumWidth = this.recommendedWidth;
            gd.widthHint = this.recommendedWidth;
        }
        canvas.setLayoutData((Object)gd);
        return canvas;
    }

    public void updateProgress(double percentage) {
        this.checkWidget();
        if (percentage < 0.0) {
            percentage = 0.0;
        } else if (percentage > 1.0) {
            percentage = 1.0;
        }
        this.progressedPercentage = percentage;
        this.progressedPosition = (int)((double)this.calculatePotentialFillExtent() * (this.horizontal ? percentage : 1.0 - percentage));
        this.fillRegion.setLayoutData((Object)this.createFilledLayoutData());
        this.layout();
    }

    private int calculatePotentialFillExtent() {
        if (this.horizontal) {
            return this.getClientArea().width - this.leftBorder.getBounds().width - this.rightBorder.getBounds().width;
        }
        return this.getClientArea().height - this.leftBorder.getBounds().height - this.rightBorder.getBounds().height;
    }

    public double getCurrentProgress() {
        this.checkWidget();
        return this.progressedPercentage;
    }

    public Point computeSize(int wHint, int hHint) {
        this.checkWidget();
        int width = this.recommendedWidth;
        int height = this.recommendedHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void setFilledImage(Image img) {
        if (this.horizontal) {
            this.fillRegion.setBackgroundImage(img);
        } else {
            this.emptyRegion.setBackgroundImage(img);
        }
        this.redraw();
    }

    public void setEmptyImage(Image img) {
        if (this.horizontal) {
            this.emptyRegion.setBackgroundImage(img);
        } else {
            this.fillRegion.setBackgroundImage(img);
        }
        this.redraw();
    }

    public void setBorderLeftImage(Image img) {
        this.leftBorder.setBackgroundImage(img);
        this.redraw();
    }

    public void setBorderRightImage(Image img) {
        this.rightBorder.setBackgroundImage(img);
        this.redraw();
    }
}

