/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.keyboard.dao;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import su.artix.yuki.keyboard.domain.KeyboardContainer;

public class XmlKeyboardDAO {
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    public static final String CLIENT_PATH = "config/keyboards";
    private FilenameFilter xmlFilter = new FilenameFilter(){

        @Override
        public boolean accept(File arg0, String fileName) {
            return fileName != null && fileName.endsWith(".xml");
        }
    };

    public XmlKeyboardDAO() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{KeyboardContainer.class});
        this.unmarshaller = context.createUnmarshaller();
        this.marshaller = context.createMarshaller();
        this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
    }

    public List<KeyboardContainer> getAll() {
        return this.getAll(CLIENT_PATH);
    }

    public List<KeyboardContainer> getAll(String directoryPath) {
        ArrayList<KeyboardContainer> keyboards = new ArrayList<KeyboardContainer>();
        File directory = new File(directoryPath);
        File[] files = directory.listFiles(this.xmlFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    KeyboardContainer keyboard = this.getKeyboard(file.getAbsolutePath());
                    if (keyboard != null) {
                        keyboards.add(keyboard);
                    }
                }
                catch (JAXBException jAXBException) {}
                ++n2;
            }
        }
        return keyboards;
    }

    public KeyboardContainer getKeyboard(String path) throws JAXBException {
        KeyboardContainer holder = null;
        File file = new File(path);
        if (file.exists()) {
            KeyboardContainer keyboard = (KeyboardContainer)this.unmarshaller.unmarshal(file);
            return keyboard;
        }
        return holder;
    }

    public void saveKeyboard(KeyboardContainer container, String path) throws JAXBException {
        File file = new File(path);
        this.marshaller.marshal((Object)container, file);
    }
}

