/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import su.artix.widgets.TextWithClearLabel;

public class SearchTextControl
extends TextWithClearLabel {
    private static String LOUPE_ACTIVE_ICON = "su.artix.widgets.loupe_active_icon";
    private static String LOUPE_INACTIVE_ICON = "su.artix.widgets.loupe_inactive_icon";
    private static String LOUPE_PRESSED_ICON = "su.artix.widgets.loupe_pressed_icon";

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/widgets/16x16/plane/loupe_active.png");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(LOUPE_ACTIVE_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/widgets/16x16/plane/loupe_inactive.png")) != null) {
            JFaceResources.getImageRegistry().put(LOUPE_INACTIVE_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"su.artix.widgets", (String)"$nl$/icons/widgets/16x16/plane/loupe_pressed.png")) != null) {
            JFaceResources.getImageRegistry().put(LOUPE_PRESSED_ICON, descriptor);
        }
    }

    public SearchTextControl(Composite parent) {
        super(parent);
    }

    @Override
    protected Composite createMainPanel() {
        final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(LOUPE_ACTIVE_ICON).createImage();
        final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(LOUPE_INACTIVE_ICON).createImage();
        final Image pressedImage = JFaceResources.getImageRegistry().getDescriptor(LOUPE_PRESSED_ICON).createImage();
        final Color bColor = Display.getCurrent().getSystemColor(25);
        GridLayoutFactory.fillDefaults().spacing(3, 0).numColumns(2).applyTo((Composite)this);
        this.setBackground(bColor);
        final Label searchBtn = new Label((Composite)this, 0);
        searchBtn.setToolTipText("\u0418\u0441\u043a\u0430\u0442\u044c");
        searchBtn.setImage(inactiveImage);
        searchBtn.setBackground(bColor);
        searchBtn.setDragDetect(false);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)searchBtn);
        searchBtn.addListener(6, new Listener(){

            public void handleEvent(Event e) {
                searchBtn.setImage(activeImage);
            }
        });
        searchBtn.addListener(7, new Listener(){

            public void handleEvent(Event e) {
                searchBtn.setImage(inactiveImage);
            }
        });
        searchBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                searchBtn.setImage(this.isMouseInButton(e) ? activeImage : inactiveImage);
                if (this.isMouseInButton(e)) {
                    SearchTextControl.this.doSearch();
                }
            }

            public void mouseDown(MouseEvent e) {
                searchBtn.setImage(pressedImage);
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = searchBtn.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        searchBtn.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        Composite mainPanel = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)mainPanel);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                activeImage.dispose();
                inactiveImage.dispose();
                pressedImage.dispose();
                bColor.dispose();
            }
        });
        return mainPanel;
    }
}

