/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.mihalis.opal.systemMonitor.Sample;

public class ThreadsUsageSample
implements Sample {
    private static final String PEAK_THREAD_COUNT = "PeakThreadCount";
    private static final String THREAD_COUNT = "ThreadCount";
    private static final String OBJECT_NAME_ATTRIBUTE = "java.lang:type=Threading";
    private final MBeanServerConnection mBeanServerConnection = ManagementFactory.getPlatformMBeanServer();
    private ObjectName objectName;

    ThreadsUsageSample() {
        try {
            this.objectName = new ObjectName(OBJECT_NAME_ATTRIBUTE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getValue() {
        try {
            return ((Integer)this.mBeanServerConnection.getAttribute(this.objectName, THREAD_COUNT)).intValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getMaxValue() {
        try {
            return ((Integer)this.mBeanServerConnection.getAttribute(this.objectName, PEAK_THREAD_COUNT)).intValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

