/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import su.artix.cashserver.security.SecurityAction;

public class SecurityActionImpl<E>
extends Action
implements SecurityAction,
ISelectionListener,
ActionFactory.IWorkbenchAction {
    private boolean securityEnabled = true;
    private Class<E> clazz;
    protected IWorkbenchWindow window;
    private boolean singleSelection;

    public SecurityActionImpl(Class<E> clazz, boolean singleSelection) {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), clazz, singleSelection);
    }

    public SecurityActionImpl(IWorkbenchWindow window, Class<E> cl, boolean singleSelection) {
        this.clazz = cl;
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.singleSelection = singleSelection;
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public Class<E> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<E> clazz) {
        this.clazz = clazz;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.setEnabled(this.securityEnabled && this.isCorrectSelectionCount(structuredSelection.size()) && this.isCorrectSelectionClass(structuredSelection.getFirstElement().getClass()));
        } else {
            this.setEnabled(false);
        }
    }

    private boolean isCorrectSelectionCount(int count) {
        if (this.singleSelection) {
            return count == 1;
        }
        return count > 0;
    }

    private boolean isCorrectSelectionClass(Class<?> selectionClass) {
        return selectionClass.equals(this.clazz) || this.clazz.isAssignableFrom(selectionClass);
    }

    public void dispose() {
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }
}

