/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.view.DirectoryViewPanel;
import su.artix.yuki.view.MementoPersistStore;
import su.artix.yuki.view.state.PersistState;
import su.artix.yuki.view.state.PersistTreeOrderState;
import su.artix.yuki.view.state.PersistTreeWidthState;

public abstract class DirectoryTreeViewPanel<P>
extends DirectoryViewPanel<P, TreeViewer> {
    private DirectorySelectDialogState selectDialogState;
    private PersistState<Tree> widthPersist;
    private PersistState<Tree> orderPersist;

    public DirectoryTreeViewPanel(Composite parent, int style, Class<P> cl, boolean selectMode) {
        super(parent, style, cl, selectMode, true, false);
    }

    public DirectoryTreeViewPanel(Composite parent, int style, Class<P> cl, boolean selectMode, boolean multiSelect) {
        super(parent, style, cl, selectMode, multiSelect, false);
    }

    @Override
    public void initPersistState(IWorkbenchPart part) {
        IWorkbenchPage page;
        if (part == null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            part = page.getActivePart();
        }
        if (part instanceof MementoPersistStore) {
            IMemento memento = ((MementoPersistStore)part).getMemento();
            if (this.widthPersist == null) {
                String tag_id = (String.valueOf(part.getClass().getName()) + "_" + ((Object)((Object)this)).getClass().getName()).replace("$", "");
                this.widthPersist = new PersistTreeWidthState(memento, tag_id);
                this.orderPersist = new PersistTreeOrderState(memento, tag_id);
            }
            this.widthPersist.restoreState(((TreeViewer)this.getViewer()).getTree());
            this.orderPersist.restoreState(((TreeViewer)this.getViewer()).getTree());
            ((TreeViewer)this.getViewer()).refresh();
        }
    }

    @Override
    public void savePersistState() {
        IMemento memento;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof MementoPersistStore && this.getViewer() != null && (memento = ((MementoPersistStore)part).getMemento()) != null && this.widthPersist != null) {
            this.widthPersist.saveState(memento, ((TreeViewer)this.getViewer()).getTree());
            this.orderPersist.saveState(memento, ((TreeViewer)this.getViewer()).getTree());
        }
    }

    @Override
    protected TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, this.getSelectionStyle() | 0x100 | 0x200 | 0x10000 | 0x10000000);
        viewer.setUseHashlookup(true);
        this.createColumns(parent, viewer);
        return viewer;
    }

    protected void createMenuItem(Menu parent, final TreeColumn column) {
        final MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (itemName.getSelection()) {
                    column.setWidth(150);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
    }

    protected void createOperationsMenuItem(Menu parent, TreeColumn column) {
        MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
    }

    @Override
    public DirectorySelectDialogState getSelectDialogState() {
        return this.selectDialogState;
    }

    @Override
    public void setSelectDialogState(DirectorySelectDialogState selectDialogState) {
        this.selectDialogState = selectDialogState;
    }

    protected Menu createMenu(Composite parent, TreeViewer viewer, String[] titles, int[] bounds) {
        Menu headerMenu = new Menu((Control)parent);
        int i = 0;
        while (i < titles.length) {
            TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 16384);
            TreeColumn column = viewerColumn.getColumn();
            column.setText(titles[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(true);
            this.createMenuItem(headerMenu, column);
            ++i;
        }
        return headerMenu;
    }
}

