/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepositoryInterfaceAwareBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    private static final Log LOG = LogFactory.getLog(RepositoryInterfaceAwareBeanPostProcessor.class);
    private static final Class<?> REPOSITORY_TYPE = RepositoryFactoryBeanSupport.class;
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private ConfigurableListableBeanFactory context;

    RepositoryInterfaceAwareBeanPostProcessor() {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.context = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (null == this.context || !REPOSITORY_TYPE.isAssignableFrom(beanClass)) {
            return null;
        }
        BeanDefinition definition = this.context.getBeanDefinition(beanName);
        PropertyValue value = definition.getPropertyValues().getPropertyValue("repositoryInterface");
        Class<?> resolvedBeanClass = this.cache.get(beanName);
        if (this.cache.containsKey(beanName)) {
            return this.cache.get(beanName);
        }
        resolvedBeanClass = this.getClassForPropertyValue(value, beanName);
        this.cache.put(beanName, resolvedBeanClass);
        return resolvedBeanClass == Void.class ? null : resolvedBeanClass;
    }

    private Class<?> getClassForPropertyValue(PropertyValue propertyValue, String beanName) {
        Object value = propertyValue.getValue();
        String className = null;
        if (value instanceof TypedStringValue) {
            className = ((TypedStringValue)value).getValue();
        } else if (value instanceof String) {
            className = (String)value;
        } else {
            if (value instanceof Class) {
                return (Class)value;
            }
            return Void.class;
        }
        try {
            return ClassUtils.resolveClassName((String)className, (ClassLoader)this.context.getBeanClassLoader());
        }
        catch (IllegalArgumentException ex) {
            LOG.warn((Object)String.format("Couldn't load class %s referenced as repository interface in bean %s!", className, beanName));
            return Void.class;
        }
    }
}

