/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentTypeAwareTypeInformation<S>
extends TypeDiscoverer<S> {
    private final TypeDiscoverer<?> parent;

    protected ParentTypeAwareTypeInformation(Type type, TypeDiscoverer<?> parent, Map<TypeVariable, Type> map) {
        super(type, map);
        this.parent = parent;
    }

    @Override
    protected Map<TypeVariable, Type> getTypeVariableMap() {
        return this.parent == null ? super.getTypeVariableMap() : this.parent.getTypeVariableMap();
    }

    @Override
    protected TypeInformation<?> createInfo(Type fieldType) {
        if (this.parent.getType().equals(fieldType)) {
            return this.parent;
        }
        return super.createInfo(fieldType);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParentTypeAwareTypeInformation that = (ParentTypeAwareTypeInformation)obj;
        return this.parent == null ? that.parent == null : this.parent.equals(that.parent);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * ObjectUtils.nullSafeHashCode(this.parent);
    }
}

