/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.menutree.dnd;

import com.rits.cloning.Cloner;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.menutree.MenuTreeModel;

public enum Paste {
    INSTANCE;

    private static final Logger log;
    private boolean isImport;

    static {
        log = LoggerFactory.getLogger(Paste.class);
    }

    public boolean isImport() {
        return this.isImport;
    }

    public void setImport(boolean isImport) {
        this.isImport = isImport;
    }

    private void pasteMenuItem(HierarchicalMenuItem parent, HierarchicalMenuItem object) throws ExecuteQueryException {
        if (parent == null || !parent.getCmaction().getCmactioncode().equals(object.getCmaction().getCmactioncode())) {
            Cloner cloner = new Cloner();
            HierarchicalMenuItem newObject = (HierarchicalMenuItem)cloner.deepClone((Object)object);
            newObject.setParent(parent);
            newObject.setMenues(new ArrayList());
            newObject.setActions(new ArrayList());
            MenuTreeModel treeModel = ModelActivator.getDefault().getModelProvider().getHierarchicalMenuItemModel();
            if (object.getMenu() == null) {
                if (this.isImport) {
                    treeModel.doImport(newObject, true);
                } else {
                    treeModel.doAdd(newObject, true);
                }
            } else if (this.isImport) {
                treeModel.doImport(newObject, false);
            } else {
                treeModel.doAdd(newObject, false);
            }
            for (HierarchicalMenuItem menu : object.getMenues()) {
                this.pasteMenuItem(newObject, menu);
            }
            for (HierarchicalMenuItem action : object.getActions()) {
                this.pasteMenuItem(newObject, action);
            }
        }
    }

    public void paste(HierarchicalMenuItem src, HierarchicalMenuItem dest, boolean isImport) {
        this.setImport(isImport);
        if (dest != null) {
            int order = 0;
            for (HierarchicalMenuItem submenu : dest.getMenues()) {
                if (submenu.getOrder() <= order) continue;
                order = submenu.getOrder();
            }
            for (HierarchicalMenuItem action : dest.getActions()) {
                if (action.getOrder() <= order) continue;
                order = action.getOrder();
            }
            src.setOrder(Integer.valueOf(order + 1));
        }
        try {
            this.pasteMenuItem(dest, src);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

