/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.notes;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ru.ssa.artixadmin.editors.directory.notes.DialogChoiceListDataModel;

public class DialogChoiceListDataEditDialog
extends Dialog {
    private DialogChoiceListDataModel dataModel;
    private List<String> headers;
    private Text field1;
    private Text field2;
    private Text field3;
    private Text field4;
    private Text field5;
    private List<Text> fields;

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 5;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(131072, 1024, false, false);
        data.horizontalSpan = 1;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        int i = 0;
        while (i < this.headers.size()) {
            if (StringUtils.isNotBlank((String)this.headers.get(i))) {
                Label keyLabel = new Label(composite, 0);
                keyLabel.setText(String.valueOf(this.headers.get(i)) + ":");
                Text field = this.createTextField(i, composite);
                field.setText(this.dataModel.getField(i) == null ? "" : this.dataModel.getField(i));
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)field);
            }
            ++i;
        }
        this.fields = Arrays.asList(this.field1, this.field2, this.field3, this.field4, this.field5);
        return parent;
    }

    private Text createTextField(int index, Composite composite) {
        if (index == 0) {
            this.field1 = new Text(composite, 2048);
            return this.field1;
        }
        if (index == 1) {
            this.field2 = new Text(composite, 2048);
            return this.field2;
        }
        if (index == 2) {
            this.field3 = new Text(composite, 2048);
            return this.field3;
        }
        if (index == 3) {
            this.field4 = new Text(composite, 2048);
            return this.field4;
        }
        this.field5 = new Text(composite, 2048);
        return this.field5;
    }

    protected Point getInitialSize() {
        return new Point(400, 260);
    }

    protected void okPressed() {
        boolean flagIsOk = true;
        int i = 0;
        while (i < this.headers.size()) {
            if (StringUtils.isNotBlank((String)this.headers.get(i))) {
                if (this.fields.get(i).getText().isEmpty()) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u0414\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u0432\u0441\u0435 \u043f\u043e\u043b\u044f!");
                    flagIsOk = false;
                    break;
                }
                this.dataModel.setField(i, this.fields.get(i).getText());
            }
            ++i;
        }
        if (flagIsOk) {
            super.okPressed();
        }
    }

    public DialogChoiceListDataEditDialog(List<String> headers, DialogChoiceListDataModel dataModel) {
        super(Display.getDefault().getActiveShell());
        this.headers = headers;
        this.dataModel = dataModel;
    }

    public DialogChoiceListDataModel getDialogChoiceListDataModel() {
        return this.dataModel;
    }

    public void setDialogChoiceListDataModel(DialogChoiceListDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    protected boolean isResizable() {
        return true;
    }
}

