/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;

public class SecurityPermissionContentProvider
implements ITreeContentProvider {
    Set<SecurityPermission> securityPermissions;

    public SecurityPermissionContentProvider(Set<SecurityPermission> securityPermissions) {
        this.securityPermissions = securityPermissions;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<SecurityPermission> rootPermissions = new ArrayList<SecurityPermission>();
        for (SecurityPermission permission : this.securityPermissions) {
            if (permission == null || permission.getSecurityObject() == null || permission.getSecurityObject().getParent() != null) continue;
            rootPermissions.add(permission);
        }
        Collections.sort(rootPermissions, new SecurityPermissionComparator());
        return rootPermissions.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<SecurityPermission> chidPermissions = new ArrayList<SecurityPermission>();
        for (SecurityPermission permission : this.securityPermissions) {
            if (permission.getSecurityObject() == null || permission.getSecurityObject().getParent() == null || !permission.getSecurityObject().getParent().equals((Object)((SecurityPermission)parentElement).getSecurityObject())) continue;
            chidPermissions.add(permission);
        }
        Collections.sort(chidPermissions, new SecurityPermissionComparator());
        return chidPermissions.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        for (SecurityPermission permission : this.securityPermissions) {
            if (permission.getSecurityObject() == null || permission.getSecurityObject().getParent() == null || !permission.getSecurityObject().getParent().equals((Object)((SecurityPermission)element).getSecurityObject())) continue;
            return true;
        }
        return false;
    }

    private class SecurityPermissionComparator
    implements Comparator<SecurityPermission> {
        private SecurityPermissionComparator() {
        }

        @Override
        public int compare(SecurityPermission o1, SecurityPermission o2) {
            return o1.getSecurityObject().getId().substring(o1.getSecurityObject().getId().lastIndexOf(".") + 1).compareToIgnoreCase(o2.getSecurityObject().getId().substring(o2.getSecurityObject().getId().lastIndexOf(".") + 1));
        }
    }
}

