/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.document;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.document.DocumentTableView;
import ru.ssa.artixadmin.view.document.NoteItemViewPanel;
import ru.ssa.artixadmin.view.document.WorkshiftTableView;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.docs.Document;
import ru.ssa.cashadmin.domain.docs.Noteitem;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f")
public class NoteItemTableView
extends DirectoryTableView<Noteitem> {
    public static final String ID = "ru.ssa.artixadmin.view.document.NoteItemTableView";
    private static final Logger log = LoggerFactory.getLogger(NoteItemTableView.class);
    private boolean firstInitial = true;

    public void createPartControl(Composite parent) {
        this.setPojoClass(Noteitem.class);
        this.setViewPanel((DirectoryViewPanel)new NoteItemViewPanel(parent, 0, true));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)new LazyContentProvider(Noteitem.class, (TableViewer)this.getViewer()));
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns(), false));
        this.commonActionGroup = new DirectoryEditActionGroup(Noteitem.class).removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryAddAction", "ru.ssa.artixadmin.action.DirectoryEditAction", "ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        super.createPartControl(parent);
        this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        if (selectionIn.isEmpty() && this.firstInitial) {
            ISelection selectionTemp = part.getSite().getPage().getSelection("ru.ssa.artixadmin.view.document.DocumentTableView");
            selectionIn = selectionTemp == null ? selectionIn : selectionTemp;
        }
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof DocumentTableView || selectionIn != null && !selectionIn.isEmpty() && this.firstInitial) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof Document) {
                Noteitem noteitem = (Noteitem)LibActivator.getDefault().getActualClassResolver().getInstance(Noteitem.class);
                Document document = (Document)selection.getFirstElement();
                noteitem.setDocumentid(document.getDocumentid());
                this.getViewPanel().setInput((Object)noteitem);
            }
        } else if (part instanceof WorkshiftTableView) {
            Noteitem noteitem = (Noteitem)LibActivator.getDefault().getActualClassResolver().getInstance(Noteitem.class);
            noteitem.setDocumentid(Integer.valueOf(-1));
            this.getViewPanel().setInput((Object)noteitem);
        }
        this.firstInitial = false;
    }

    protected String getID() {
        return ID;
    }
}

