/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Dept;
import ru.ssa.cashadmin.domain.Valut;
import ru.ssa.cashadmin.domain.ValutDeptPK;

@Entity
@Table(name="payforbiddance")
@MappedSuperclass
public class PayForbiddance
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ValutDeptPK valutdeptPK = new ValutDeptPK();
    @ManyToOne
    @JoinColumn(name="deptcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Dept dept;
    @Column(name="deptcode", insertable=false, updatable=false)
    private Integer deptcode;
    @Column(name="valutcode", insertable=false, updatable=false)
    private Integer valutcode;
    @ManyToOne
    @JoinColumn(name="valutcode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Valut.class)
    private Valut valut;

    protected PayForbiddance() {
    }

    public PayForbiddance(Dept dept, Valut valut) {
        this.setDept(dept);
        this.setValut(valut);
    }

    public ValutDeptPK getValutdeptPK() {
        return this.valutdeptPK;
    }

    public Valut getValut() {
        return this.valut;
    }

    public void setValutdeptPK(ValutDeptPK valutdeptPK) {
        this.valutdeptPK = valutdeptPK;
    }

    public void setValut(Valut valut) {
        this.valut = valut;
        if (valut != null) {
            this.valutdeptPK.setValutcode(valut.getCode());
        } else {
            this.valutdeptPK.setValutcode(null);
        }
    }

    public Dept getDept() {
        return this.dept;
    }

    public void setDept(Dept dept) {
        this.dept = dept;
        if (dept != null) {
            this.valutdeptPK.setDeptcode(dept.getCode());
        } else {
            this.valutdeptPK.setDeptcode(null);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Valutdept [valutdeptPK=");
        builder.append(this.valutdeptPK);
        builder.append(", valut=");
        builder.append(this.valut);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.valutdeptPK == null ? 0 : this.valutdeptPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayForbiddance other = (PayForbiddance)obj;
        return !(this.valutdeptPK == null ? other.valutdeptPK != null : !this.valutdeptPK.equals(other.valutdeptPK));
    }

    public Integer getValutcode() {
        return this.valutcode;
    }

    public void setValutcode(Integer valutcode) {
        this.valutcode = valutcode;
    }

    public Integer getDeptcode() {
        return this.deptcode;
    }

    public void setDeptcode(Integer deptcode) {
        this.deptcode = deptcode;
    }
}

