/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.dict.notes;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import ru.ssa.cashadmin.domain.BaseJavaBean;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsChoice;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsChoiceList;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsInputMultiText;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsInputText;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsMessage;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsMultiChoice;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsSimpleChoice;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamsTextInfo;
import ru.ssa.cashadmin.domain.dict.notes.ExecComandLine;
import ru.ssa.cashadmin.domain.dict.notes.ExecScript;
import ru.ssa.cashadmin.domain.dict.notes.JsonDialogParams;
import ru.ssa.cashadmin.domain.dict.notes.JsonExecutableParams;

public class DialogParamContainer
extends BaseJavaBean
implements Serializable {
    private String dialogType;
    private DialogParamsChoice dialogChoice;
    private DialogParamsChoiceList dialogChoiceList;
    private DialogParamsInputMultiText dialogInputMultiText;
    private DialogParamsInputText dialogInputText;
    private DialogParamsMessage dialogMessage;
    private DialogParamsMultiChoice dialogMultiChoice;
    private DialogParamsSimpleChoice dialogSimpleChoice;
    private DialogParamsTextInfo showTextInfo;
    private ExecScript executable;
    private ExecComandLine commandLine;

    public DialogParamContainer() {
        this.dialogChoice = new DialogParamsChoice();
        this.dialogChoiceList = new DialogParamsChoiceList();
        this.dialogInputMultiText = new DialogParamsInputMultiText();
        this.dialogInputText = new DialogParamsInputText();
        this.dialogMessage = new DialogParamsMessage();
        this.dialogMultiChoice = new DialogParamsMultiChoice();
        this.dialogSimpleChoice = new DialogParamsSimpleChoice();
        this.showTextInfo = new DialogParamsTextInfo();
        this.executable = new ExecScript();
        this.commandLine = new ExecComandLine();
    }

    public DialogParamContainer(JsonDialogParams paramsJson) {
        block28: {
            this.dialogChoice = new DialogParamsChoice();
            this.dialogChoiceList = new DialogParamsChoiceList();
            this.dialogInputMultiText = new DialogParamsInputMultiText();
            this.dialogInputText = new DialogParamsInputText();
            this.dialogMessage = new DialogParamsMessage();
            this.dialogMultiChoice = new DialogParamsMultiChoice();
            this.dialogSimpleChoice = new DialogParamsSimpleChoice();
            this.showTextInfo = new DialogParamsTextInfo();
            this.executable = new ExecScript();
            this.commandLine = new ExecComandLine();
            if (paramsJson == null || !StringUtils.isNotEmpty((String)paramsJson.getDialogType())) break block28;
            this.dialogType = paramsJson.getDialogType();
            switch (paramsJson.getDialogType()) {
                case "dialogInputText": {
                    this.dialogInputText = new DialogParamsInputText(paramsJson);
                    break;
                }
                case "dialogMessage": {
                    this.dialogMessage = new DialogParamsMessage(paramsJson);
                    break;
                }
                case "dialogChoice": {
                    this.dialogChoice = new DialogParamsChoice(paramsJson);
                    break;
                }
                case "dialogChoiceList": {
                    this.dialogChoiceList = new DialogParamsChoiceList(paramsJson);
                    break;
                }
                case "dialogInputMultiText": {
                    this.dialogInputMultiText = new DialogParamsInputMultiText(paramsJson);
                    break;
                }
                case "dialogMultiChoice": {
                    this.dialogMultiChoice = new DialogParamsMultiChoice(paramsJson);
                    break;
                }
                case "dialogSimpleChoice": {
                    this.dialogSimpleChoice = new DialogParamsSimpleChoice(paramsJson);
                    break;
                }
                case "showTextInfo": {
                    this.showTextInfo = new DialogParamsTextInfo(paramsJson);
                    break;
                }
            }
        }
    }

    public DialogParamContainer(JsonExecutableParams paramsJson) {
        this.dialogChoice = new DialogParamsChoice();
        this.dialogChoiceList = new DialogParamsChoiceList();
        this.dialogInputMultiText = new DialogParamsInputMultiText();
        this.dialogInputText = new DialogParamsInputText();
        this.dialogMessage = new DialogParamsMessage();
        this.dialogMultiChoice = new DialogParamsMultiChoice();
        this.dialogSimpleChoice = new DialogParamsSimpleChoice();
        this.showTextInfo = new DialogParamsTextInfo();
        this.executable = new ExecScript();
        this.commandLine = new ExecComandLine();
        if (StringUtils.isNotBlank((String)paramsJson.getExecutable())) {
            this.executable = new ExecScript(paramsJson);
            this.dialogType = "executable";
        } else {
            this.commandLine = new ExecComandLine(paramsJson);
            this.dialogType = "commandLine";
        }
    }

    public DialogParamContainer(String dialogType) {
        this.dialogChoice = new DialogParamsChoice();
        this.dialogChoiceList = new DialogParamsChoiceList();
        this.dialogInputMultiText = new DialogParamsInputMultiText();
        this.dialogInputText = new DialogParamsInputText();
        this.dialogMessage = new DialogParamsMessage();
        this.dialogMultiChoice = new DialogParamsMultiChoice();
        this.dialogSimpleChoice = new DialogParamsSimpleChoice();
        this.showTextInfo = new DialogParamsTextInfo();
        this.executable = new ExecScript();
        this.commandLine = new ExecComandLine();
        this.dialogType = dialogType;
        switch (dialogType) {
            case "dialogInputText": {
                this.dialogInputText = new DialogParamsInputText();
                break;
            }
            case "dialogMessage": {
                this.dialogMessage = new DialogParamsMessage();
                break;
            }
            case "dialogChoice": {
                this.dialogChoice = new DialogParamsChoice();
                break;
            }
            case "dialogChoiceList": {
                this.dialogChoiceList = new DialogParamsChoiceList();
                break;
            }
            case "dialogInputMultiText": {
                this.dialogInputMultiText = new DialogParamsInputMultiText();
                break;
            }
            case "dialogMultiChoice": {
                this.dialogMultiChoice = new DialogParamsMultiChoice();
                break;
            }
            case "dialogSimpleChoice": {
                this.dialogSimpleChoice = new DialogParamsSimpleChoice();
                break;
            }
            case "showTextInfo": {
                this.showTextInfo = new DialogParamsTextInfo();
                break;
            }
            case "executable": {
                this.executable = new ExecScript();
                break;
            }
            case "commandLine": {
                this.commandLine = new ExecComandLine();
                break;
            }
        }
    }

    public JsonDialogParams toJsonDialogParams() {
        block28: {
            if (!StringUtils.isNotEmpty((String)this.dialogType)) break block28;
            switch (this.dialogType) {
                case "dialogInputText": {
                    return this.dialogInputText.toJsonDialogParams();
                }
                case "dialogMessage": {
                    return this.dialogMessage.toJsonDialogParams();
                }
                case "dialogChoice": {
                    return this.dialogChoice.toJsonDialogParams();
                }
                case "dialogChoiceList": {
                    return this.dialogChoiceList.toJsonDialogParams();
                }
                case "dialogInputMultiText": {
                    return this.dialogInputMultiText.toJsonDialogParams();
                }
                case "dialogMultiChoice": {
                    return this.dialogMultiChoice.toJsonDialogParams();
                }
                case "dialogSimpleChoice": {
                    return this.dialogSimpleChoice.toJsonDialogParams();
                }
                case "showTextInfo": {
                    return this.showTextInfo.toJsonDialogParams();
                }
            }
        }
        return null;
    }

    public JsonExecutableParams toJsonExecutableParams() {
        block10: {
            if (!StringUtils.isNotEmpty((String)this.dialogType)) break block10;
            switch (this.dialogType) {
                case "executable": {
                    return this.executable.toJsonDialogParams();
                }
                case "commandLine": {
                    return this.commandLine.toJsonDialogParams();
                }
            }
        }
        return null;
    }

    public String getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(String dialogType) {
        this.dialogType = dialogType;
    }

    public DialogParamsChoice getDialogChoice() {
        return this.dialogChoice;
    }

    public void setDialogChoice(DialogParamsChoice dialogChoice) {
        this.dialogChoice = dialogChoice;
    }

    public DialogParamsChoiceList getDialogChoiceList() {
        return this.dialogChoiceList;
    }

    public void setDialogChoiceList(DialogParamsChoiceList dialogChoiceList) {
        this.dialogChoiceList = dialogChoiceList;
    }

    public DialogParamsInputMultiText getDialogInputMultiText() {
        return this.dialogInputMultiText;
    }

    public void setDialogInputMultiText(DialogParamsInputMultiText dialogInputMultiText) {
        this.dialogInputMultiText = dialogInputMultiText;
    }

    public DialogParamsInputText getDialogInputText() {
        return this.dialogInputText;
    }

    public void setDialogInputText(DialogParamsInputText dialogInputText) {
        this.dialogInputText = dialogInputText;
    }

    public DialogParamsMessage getDialogMessage() {
        return this.dialogMessage;
    }

    public void setDialogMessage(DialogParamsMessage dialogMessage) {
        this.dialogMessage = dialogMessage;
    }

    public DialogParamsMultiChoice getDialogMultiChoice() {
        return this.dialogMultiChoice;
    }

    public void setDialogMultiChoice(DialogParamsMultiChoice dialogMultiChoice) {
        this.dialogMultiChoice = dialogMultiChoice;
    }

    public DialogParamsSimpleChoice getDialogSimpleChoice() {
        return this.dialogSimpleChoice;
    }

    public void setDialogSimpleChoice(DialogParamsSimpleChoice dialogSimpleChoice) {
        this.dialogSimpleChoice = dialogSimpleChoice;
    }

    public DialogParamsTextInfo getShowTextInfo() {
        return this.showTextInfo;
    }

    public void setShowTextInfo(DialogParamsTextInfo showTextInfo) {
        this.showTextInfo = showTextInfo;
    }

    public ExecScript getExecutable() {
        return this.executable;
    }

    public void setExecutable(ExecScript executable) {
        this.executable = executable;
    }

    public ExecComandLine getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(ExecComandLine commandLine) {
        this.commandLine = commandLine;
    }
}

