/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import com.ibm.icu.math.BigDecimal;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionMultiIntControl;

public class DiscountConditionMultiDoubleControl
extends DiscountConditionMultiIntControl {
    public DiscountConditionMultiDoubleControl(Composite parent, String labelName, String defaultValue) {
        super(parent, labelName, defaultValue);
    }

    @Override
    public Control createControl(Composite parent, String defaultValue) {
        Spinner spinner = new Spinner(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)spinner);
        spinner.setMaximum(Integer.MAX_VALUE);
        int digits = 2;
        spinner.setDigits(digits);
        spinner.setIncrement((int)Math.pow(10.0, digits));
        if (defaultValue != null) {
            try {
                BigDecimal val = BigDecimal.valueOf((double)Double.valueOf(defaultValue));
                spinner.setSelection(val.multiply(new BigDecimal(100)).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                spinner.setSelection(0);
            }
        } else {
            spinner.setSelection(0);
        }
        return spinner;
    }

    @Override
    public String getControlText(Control control) {
        return super.getControlText(control).replace(',', '.');
    }
}

