/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountPropertyFirstWizardPage;
import su.artix.discountmanager.dialogs.discountsystem.wizard.DiscountPropertySecondWizardPage;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;

@SecurityKey(title="\u041c\u0430\u0441\u0442\u0435\u0440 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439")
public class DiscountPropertyWizard
extends Wizard {
    private Discount discount;
    private Discount newDiscount;
    private IWizardPage page1;
    private IWizardPage page2;

    public DiscountPropertyWizard(Discount discount) {
        this.discount = discount;
        this.newDiscount = this.copy(discount, new Discount(""));
        this.page1 = new DiscountPropertyFirstWizardPage("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u043a\u0438\u0434\u043a\u0438", this.newDiscount);
        this.page2 = new DiscountPropertySecondWizardPage("\u0422\u0435\u043a\u0441\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439", this.newDiscount);
    }

    public boolean performFinish() {
        this.newDiscount.addDiscountObject(FieldsUtils.createDiscountObjectByClassName(this.newDiscount.getTypeOfDiscount(), DiscountObject.class));
        this.copy(this.newDiscount, this.discount);
        return true;
    }

    public void addPages() {
        this.addPage(this.page1);
        this.addPage(this.page2);
    }

    private Discount copy(Discount source, Discount target) {
        target.setActive(source.getActive());
        target.setName(source.getName());
        target.setId(source.getId());
        target.setClientText(source.getClientText());
        target.setClientDisplayText(source.getClientDisplayText());
        target.setCashText(source.getCashText());
        target.setMinPriceIgnored(source.getMinPriceIgnored());
        target.setTypeOfDiscount(source.getTypeOfDiscount());
        if (source.getDiscountRate() != null) {
            target.setDiscountRate(source.getDiscountRate());
        }
        if (source.getDiscountObject() != null) {
            target.addDiscountObject(source.getDiscountObject());
        }
        return target;
    }
}

