/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.List;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.DateHelper;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.nebula.widgets.ganttchart.IPaintManager;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractPaintManager
implements IPaintManager {
    public void redrawStarting() {
    }

    public void drawEvent(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, boolean isSelected, boolean threeDee, int dayWidth, int xStart, int y, int eventWidth, Rectangle bounds) {
        boolean alpha = colorManager.useAlphaDrawing();
        int xLoc = xStart;
        gc.setForeground(colorManager.getEventBorderColor());
        if (isSelected && settings.drawSelectionMarkerAroundSelectedEvent()) {
            boolean oobRight;
            gc.setLineStyle(3);
            boolean oobLeft = xLoc < bounds.x;
            boolean bl = oobRight = xLoc + eventWidth > bounds.width;
            if (oobLeft || oobRight) {
                if (!oobLeft || !oobRight) {
                    if (oobLeft) {
                        gc.drawLine(xLoc, y, xLoc + eventWidth, y);
                        gc.drawLine(xLoc + eventWidth, y, xLoc + eventWidth, y + event.getHeight());
                        gc.drawLine(xLoc, y + event.getHeight(), xLoc + eventWidth, y + event.getHeight());
                    } else {
                        gc.drawLine(xLoc, y, bounds.width, y);
                        gc.drawLine(xLoc, y, xLoc, y + event.getHeight());
                        gc.drawLine(xLoc, y + event.getHeight(), bounds.width, y + event.getHeight());
                    }
                } else {
                    gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                    gc.drawLine(bounds.x, y + event.getHeight(), bounds.x + bounds.width, y + event.getHeight());
                }
            } else {
                gc.drawRectangle(xLoc, y, eventWidth, settings.getEventHeight());
            }
            gc.setLineStyle(1);
        } else {
            gc.drawRectangle(xLoc, y, eventWidth, settings.getEventHeight());
        }
        Color cEvent = event.getStatusColor();
        Color gradient = event.getGradientStatusColor();
        if (cEvent == null) {
            cEvent = settings.getDefaultEventColor();
        }
        if (gradient == null) {
            gradient = settings.getDefaultGradientEventColor();
        }
        gc.setBackground(cEvent);
        if (settings.showGradientEventBars()) {
            gc.setForeground(gradient);
            gc.fillGradientRectangle(xLoc + 1, y + 1, eventWidth - 1, settings.getEventHeight() - 1, true);
            gc.setForeground(colorManager.getEventBorderColor());
        } else {
            gc.fillRectangle(xLoc + 1, y + 1, eventWidth - 1, settings.getEventHeight() - 1);
        }
        if (threeDee) {
            boolean subAlpha = colorManager.useAlphaDrawingOn3DEventDropShadows();
            if (subAlpha) {
                gc.setAlpha(200);
            }
            gc.setForeground(colorManager.getFadeOffColor1());
            gc.drawLine(xLoc, y + settings.getEventHeight() + 1, xLoc + eventWidth + 1, y + settings.getEventHeight() + 1);
            gc.drawLine(xLoc + eventWidth + 1, y + 2, xLoc + eventWidth + 1, y + settings.getEventHeight());
            if (subAlpha) {
                gc.setAlpha(100);
            }
            gc.setForeground(colorManager.getFadeOffColor2());
            gc.drawLine(xLoc, y + settings.getEventHeight() + 2, xLoc + eventWidth + 1, y + settings.getEventHeight() + 2);
            if (subAlpha) {
                gc.setAlpha(50);
            }
            gc.setForeground(colorManager.getFadeOffColor1());
            gc.drawLine(xLoc, y + settings.getEventHeight() + 3, xLoc + eventWidth + 1, y + settings.getEventHeight() + 3);
            gc.drawLine(xLoc + eventWidth + 2, y + 3, xLoc + eventWidth + 2, y + settings.getEventHeight() + 1);
            if (subAlpha) {
                gc.setAlpha(255);
                gc.setAdvanced(false);
            }
        }
        if (event.getPercentComplete() > 0 && event.getPercentComplete() <= 100) {
            int yStart = y + settings.getEventHeight() / 2 - 1;
            float perc = (float)event.getPercentComplete() / 100.0f;
            float toDraw = (float)eventWidth * perc;
            int remainder = eventWidth - (int)toDraw;
            if (alpha) {
                gc.setAlpha(settings.getPercentageBarAlpha());
            }
            gc.setForeground(colorManager.getPercentageBarColorTop());
            gc.setBackground(colorManager.getPercentageBarColorBottom());
            gc.fillGradientRectangle(++xLoc, yStart - settings.getEventPercentageBarHeight() / 2 + 1, (int)(toDraw -= 1.0f), settings.getEventPercentageBarHeight(), true);
            if (settings.drawFullPercentageBar()) {
                if (alpha) {
                    gc.setAlpha(settings.getRemainderPercentageBarAlpha());
                }
                gc.setForeground(colorManager.getPercentageBarRemainderColorTop());
                gc.setBackground(colorManager.getPercentageBarRemainderColorBottom());
                gc.fillGradientRectangle(xLoc + (int)toDraw, yStart - settings.getEventPercentageBarHeight() / 2 + 1, remainder, settings.getEventPercentageBarHeight(), true);
            }
            if (alpha) {
                gc.setAlpha(255);
                gc.setAdvanced(false);
            }
        }
    }

    public void drawCheckpoint(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, boolean threeDee, int dayWidth, int x, int y, Rectangle bounds) {
        Color cEvent = event.getStatusColor();
        if (cEvent == null) {
            cEvent = settings.getDefaultEventColor();
        }
        gc.setBackground(cEvent);
        int height = settings.getEventHeight();
        long days = DateHelper.daysBetween(event.getActualStartDate(), event.getActualEndDate());
        this.drawCheckpointMarker(gc, settings, colorManager, event, threeDee, x, y, dayWidth, height, bounds);
        if (days != 0L) {
            int width = (int)days * dayWidth;
            this.drawCheckpointMarker(gc, settings, colorManager, event, threeDee, x + width, y, dayWidth, height, bounds);
            int neg = height / 2 - 1;
            Rectangle rect = new Rectangle(x + dayWidth, y + neg, width - dayWidth, neg);
            gc.setForeground(colorManager.getBlack());
            gc.fillRectangle(rect);
            gc.drawRectangle(rect);
            if (settings.showBarsIn3D()) {
                boolean alpha;
                boolean bl = alpha = colorManager.useAlphaDrawing() || colorManager.useAlphaDrawingOn3DEventDropShadows();
                if (alpha) {
                    gc.setAlpha(200);
                }
                gc.setForeground(colorManager.getFadeOffColor1());
                gc.drawLine(rect.x + 1, rect.y + rect.height + 1, rect.x + rect.width - 1, rect.y + rect.height + 1);
                if (alpha) {
                    gc.setAlpha(100);
                }
                gc.setForeground(colorManager.getFadeOffColor2());
                gc.drawLine(rect.x + 1, rect.y + rect.height + 2, rect.x + rect.width - 1, rect.y + rect.height + 2);
                if (alpha) {
                    gc.setAlpha(50);
                }
                gc.setForeground(colorManager.getFadeOffColor3());
                gc.drawLine(rect.x + 1, rect.y + rect.height + 3, rect.x + rect.width - 1, rect.y + rect.height + 3);
                if (alpha) {
                    gc.setAlpha(255);
                    gc.setAdvanced(false);
                }
            }
        }
    }

    private void drawCheckpointMarker(GC gc, ISettings settings, IColorManager colorManager, GanttEvent event, boolean threeDee, int x, int y, int width, int height, Rectangle bounds) {
        float fHoriSpacer = (float)width * 0.17f;
        int hSpacer = (int)fHoriSpacer;
        float fVertiSpacer = (float)height * 0.23f;
        int vSpacer = (int)fVertiSpacer;
        Rectangle topToBottom = new Rectangle(x + hSpacer, y, width - hSpacer * 2, height + vSpacer);
        Rectangle leftToRight = new Rectangle(x, y + vSpacer, width, height - vSpacer);
        Rectangle inner = new Rectangle(x + hSpacer, y + vSpacer, width - hSpacer * 2, height - vSpacer * 2);
        Color cEvent = event.getStatusColor();
        Color gradient = event.getGradientStatusColor();
        if (cEvent == null) {
            cEvent = settings.getDefaultEventColor();
        }
        if (gradient == null) {
            gradient = settings.getDefaultGradientEventColor();
        }
        gc.setForeground(gradient);
        gc.setBackground(cEvent);
        gc.fillRectangle(topToBottom);
        gc.fillRectangle(leftToRight);
        gc.fillGradientRectangle(inner.x, inner.y, inner.width, inner.height, true);
        gc.setForeground(colorManager.getBlack());
        gc.drawRectangle(topToBottom);
        gc.drawRectangle(leftToRight);
        if (threeDee) {
            boolean alpha;
            boolean bl = alpha = colorManager.useAlphaDrawing() || colorManager.useAlphaDrawingOn3DEventDropShadows();
            if (alpha) {
                gc.setAlpha(200);
            }
            gc.setForeground(colorManager.getFadeOffColor1());
            gc.drawLine(leftToRight.x, leftToRight.y + leftToRight.height + 1, leftToRight.x + hSpacer - 1, leftToRight.y + leftToRight.height + 1);
            gc.drawLine(leftToRight.x + hSpacer, leftToRight.y + leftToRight.height + vSpacer + 1, leftToRight.x - hSpacer + leftToRight.width, leftToRight.y + leftToRight.height + vSpacer + 1);
            gc.drawLine(leftToRight.x + leftToRight.width - hSpacer + 1, leftToRight.y + leftToRight.height + 1, leftToRight.x + leftToRight.width + 1, leftToRight.y + leftToRight.height + 1);
            gc.drawLine(leftToRight.x + leftToRight.width + 1, leftToRight.y + 2, leftToRight.x + leftToRight.width + 1, leftToRight.y + leftToRight.height + 1);
            if (alpha) {
                gc.setAlpha(100);
            }
            gc.setForeground(colorManager.getFadeOffColor2());
            gc.drawLine(leftToRight.x, leftToRight.y + leftToRight.height + 2, leftToRight.x + hSpacer - 1, leftToRight.y + leftToRight.height + 2);
            gc.drawLine(leftToRight.x + hSpacer, leftToRight.y + leftToRight.height + vSpacer + 2, leftToRight.x - hSpacer + leftToRight.width, leftToRight.y + leftToRight.height + vSpacer + 2);
            gc.drawLine(leftToRight.x + leftToRight.width - hSpacer + 1, leftToRight.y + leftToRight.height + 2, leftToRight.x + leftToRight.width + 1, leftToRight.y + leftToRight.height + 2);
            gc.drawLine(leftToRight.x + leftToRight.width + 2, leftToRight.y + 3, leftToRight.x + leftToRight.width + 2, leftToRight.y + leftToRight.height + 1);
            if (alpha) {
                gc.setAlpha(50);
            }
            gc.setForeground(colorManager.getFadeOffColor3());
            gc.drawLine(leftToRight.x, leftToRight.y + leftToRight.height + 3, leftToRight.x + hSpacer - 1, leftToRight.y + leftToRight.height + 3);
            gc.drawLine(leftToRight.x + hSpacer, leftToRight.y + leftToRight.height + vSpacer + 3, leftToRight.x - hSpacer + leftToRight.width, leftToRight.y + leftToRight.height + vSpacer + 3);
            gc.drawLine(leftToRight.x + leftToRight.width - hSpacer + 1, leftToRight.y + leftToRight.height + 3, leftToRight.x + leftToRight.width + 1, leftToRight.y + leftToRight.height + 3);
            gc.drawLine(leftToRight.x + leftToRight.width + 3, leftToRight.y + 4, leftToRight.x + leftToRight.width + 3, leftToRight.y + leftToRight.height + 1);
            if (alpha) {
                gc.setAlpha(255);
                gc.setAdvanced(false);
            }
        }
    }

    public void drawPlannedDates(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, boolean threeDee, int x, int y, int eventWidth, Rectangle bounds) {
        int ys;
        int spacer = settings.getRevisedLineSpacer();
        if (event.isScope()) {
            return;
        }
        if (event.getStartDate() != null) {
            int xs = ganttComposite.getStartingXFor(event.getStartDate());
            ys = y - spacer;
            gc.setForeground(colorManager.getRevisedStartColor());
            gc.drawLine(xs, ys, x, ys);
            gc.drawLine(xs, ys - 3, xs, ys + 3);
            gc.drawLine(x, ys - 3, x, ys + 3);
        }
        if (event.getEndDate() != null) {
            int xe = ganttComposite.getStartingXFor(event.getEndDate());
            ys = y + settings.getEventHeight() + spacer;
            gc.setForeground(colorManager.getRevisedEndColor());
            gc.drawLine(xe += ganttComposite.getDayWidth(), ys, x + eventWidth, ys);
            gc.drawLine(xe, ys - 3, xe, ys + 3);
            gc.drawLine(x + eventWidth, ys - 3, x + eventWidth, ys + 3);
        }
    }

    public void drawDaysOnChart(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, boolean threeDee, int x, int y, int eventWidth, int daysNumber, Rectangle bounds) {
        if (event.isImage()) {
            return;
        }
        int top = y - 2;
        int xE = x + eventWidth;
        int middle = x + (xE - x) / 2;
        int yMiddle = event.getY() + event.getHeight() / 2;
        StringBuffer buf = new StringBuffer();
        buf.append(daysNumber);
        String dayString = buf.toString();
        Point extent = gc.stringExtent(dayString);
        Point unmodified = new Point(extent.x, extent.y);
        extent.x = extent.x + 4 + 2;
        Color gradient = event.getGradientStatusColor();
        if (gradient == null) {
            gradient = settings.getDefaultGradientEventColor();
        }
        if (middle - extent.x > x) {
            gc.setBackground(gradient);
            gc.fillRectangle(middle - extent.x / 2, top, extent.x, settings.getEventHeight() + 4);
            gc.setForeground(colorManager.getTextColor());
            gc.drawRectangle(middle - extent.x / 2, top, extent.x, settings.getEventHeight() + 4);
            gc.drawString(dayString, middle - unmodified.x + unmodified.x / 2 + 1, yMiddle -= unmodified.y / 2, true);
        }
    }

    public void drawEventString(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, String toDraw, boolean threeDee, int x, int y, int eventWidth, Rectangle bounds) {
        int textEndX = 0;
        int yTextPos = y + event.getHeight() / 2;
        Font oldFont = null;
        gc.setForeground(colorManager.getTextColor());
        if (event.showBoldText()) {
            oldFont = gc.getFont();
            FontData[] old = oldFont.getFontData();
            old[0].setStyle(1);
            Font f = new Font((Device)Display.getDefault(), old);
            gc.setFont(f);
            f.dispose();
        }
        if (event.getTextFont() != null) {
            gc.setFont(event.getTextFont());
        }
        Point toDrawExtent = event.getNameExtent();
        int textSpacer = ganttComposite.isConnected(event) ? settings.getTextSpacerConnected() : settings.getTextSpacerNonConnected();
        int textXStart = 0;
        switch (event.getHorizontalTextLocation()) {
            case 16384: {
                textXStart = x - textSpacer - toDrawExtent.x;
                break;
            }
            case 0x1000000: {
                textXStart = x + eventWidth / 2 - toDrawExtent.x / 2;
                break;
            }
            case 131072: {
                int eventOrPictureWidth = eventWidth;
                if (!settings.scaleImageToDayWidth() && event.getPicture() != null) {
                    eventOrPictureWidth = Math.max(eventOrPictureWidth, event.getPicture().getImageData().width / 2);
                }
                textXStart = x + eventOrPictureWidth + textSpacer;
                break;
            }
        }
        switch (event.getVerticalTextLocation()) {
            case 128: {
                yTextPos = event.getY() - toDrawExtent.y;
                break;
            }
            case 0x1000000: {
                yTextPos -= toDrawExtent.y / 2 - 1;
                break;
            }
            case 1024: {
                yTextPos = event.getBottomY();
                break;
            }
        }
        gc.drawString(toDraw, textXStart, yTextPos, true);
        int extra = textSpacer + toDrawExtent.x;
        textEndX = x + eventWidth + extra;
        if (event.isLocked()) {
            Image lockImage = settings.getLockImage();
            if (textEndX != 0 && lockImage != null) {
                gc.drawImage(lockImage, textEndX, y);
                extra += lockImage.getBounds().width;
            }
        }
        event.setWidthWithText(event.getWidth() + extra);
        gc.setFont(oldFont);
    }

    public void drawScope(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, boolean threeDee, int dayWidth, int x, int y, int eventWidth, Rectangle bounds) {
        List scopeEvents = event.getScopeEvents();
        if (scopeEvents.isEmpty()) {
            return;
        }
        gc.setForeground(colorManager.getScopeGradientColorTop());
        gc.setBackground(colorManager.getScopeGradientColorBottom());
        gc.fillGradientRectangle(x, y, eventWidth, settings.getEventHeight() - 5, true);
        gc.setForeground(colorManager.getScopeBorderColor());
        gc.drawRectangle(new Rectangle(x, y, eventWidth, settings.getEventHeight() - 5));
        gc.setForeground(colorManager.getScopeGradientColorTop());
        gc.setBackground(colorManager.getScopeGradientColorBottom());
        gc.fillGradientRectangle(x, y, dayWidth / 2, settings.getEventHeight(), true);
        gc.fillGradientRectangle(x + eventWidth + dayWidth / 2 - dayWidth, y, dayWidth / 2, settings.getEventHeight(), true);
        gc.setForeground(colorManager.getScopeBorderColor());
        gc.drawRectangle(x, y, dayWidth / 2, settings.getEventHeight());
        gc.drawRectangle(x + eventWidth + dayWidth / 2 - dayWidth, y, dayWidth / 2, settings.getEventHeight());
        if (threeDee) {
            boolean alpha;
            boolean bl = alpha = colorManager.useAlphaDrawing() || colorManager.useAlphaDrawingOn3DEventDropShadows();
            if (alpha) {
                gc.setAlpha(200);
            }
            gc.setForeground(colorManager.getFadeOffColor1());
            gc.drawLine(x, y + settings.getEventHeight() + 1, x + dayWidth / 2, y + settings.getEventHeight() + 1);
            gc.drawLine(x + eventWidth - dayWidth / 2, y + settings.getEventHeight() + 1, x + eventWidth, y + settings.getEventHeight() + 1);
            gc.drawLine(x + dayWidth / 2 + 1, y + settings.getEventHeight() - 4, x + eventWidth - dayWidth / 2 - 1, y + settings.getEventHeight() - 4);
            if (alpha) {
                gc.setAlpha(100);
            }
            gc.setForeground(colorManager.getFadeOffColor2());
            gc.drawLine(x, y + settings.getEventHeight() + 2, x + dayWidth / 2, y + settings.getEventHeight() + 2);
            gc.drawLine(x + eventWidth - dayWidth / 2, y + settings.getEventHeight() + 2, x + eventWidth, y + settings.getEventHeight() + 2);
            gc.drawLine(x + dayWidth / 2 + 1, y + settings.getEventHeight() - 3, x + eventWidth - dayWidth / 2 - 1, y + settings.getEventHeight() - 3);
            if (alpha) {
                gc.setAlpha(50);
            }
            gc.setForeground(colorManager.getFadeOffColor3());
            gc.drawLine(x, y + settings.getEventHeight() + 3, x + dayWidth / 2, y + settings.getEventHeight() + 3);
            gc.drawLine(x + eventWidth - dayWidth / 2, y + settings.getEventHeight() + 3, x + eventWidth, y + settings.getEventHeight() + 3);
            gc.drawLine(x + dayWidth / 2 + 1, y + settings.getEventHeight() - 2, x + eventWidth - dayWidth / 2 - 1, y + settings.getEventHeight() - 2);
            if (alpha) {
                gc.setAlpha(255);
                gc.setAdvanced(false);
            }
        }
    }

    public void drawImage(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent event, GC gc, Image image, boolean threeDee, int dayWidth, int xLoc, int yStart, Rectangle fullBounds) {
        int y = yStart;
        int x = xLoc;
        if (image == null) {
            gc.setForeground(colorManager.getBlack());
            gc.drawRectangle(x, y, dayWidth, settings.getEventHeight());
            gc.drawLine(x, y, x + dayWidth, y + settings.getEventHeight());
            gc.drawLine(x + dayWidth, y, x, y + settings.getEventHeight());
            return;
        }
        Rectangle bounds = image.getBounds();
        if (settings.scaleImageToDayWidth() && bounds.width > dayWidth) {
            ImageData id = image.getImageData();
            int diff = id.width - dayWidth;
            id.width -= diff;
            id.height -= diff;
            Image temp = new Image((Device)Display.getDefault(), id);
            int negY = bounds.height - settings.getEventHeight();
            if (negY > 0) {
                y += negY / 2;
            }
            gc.drawImage(temp, x, y);
            temp.dispose();
            return;
        }
        gc.drawImage(image, x -= (bounds.width - dayWidth) / 2, y);
    }

    public void drawArrowHead(int x, int y, int face, GC gc) {
        switch (face) {
            case 128: {
                gc.drawLine(x, y + 3, x, y + 3);
                gc.drawLine(x - 1, y + 4, x + 1, y + 4);
                gc.drawLine(x - 2, y + 5, x + 2, y + 5);
                gc.drawLine(x - 3, y + 6, x + 3, y + 6);
                gc.drawLine(x - 4, y + 7, x + 4, y + 7);
                break;
            }
            case 1024: {
                gc.drawLine(x, y + 7, x, y + 7);
                gc.drawLine(x - 1, y + 6, x + 1, y + 6);
                gc.drawLine(x - 2, y + 5, x + 2, y + 5);
                gc.drawLine(x - 3, y + 4, x + 3, y + 4);
                gc.drawLine(x - 4, y + 3, x + 4, y + 3);
                break;
            }
            case 131072: {
                gc.drawLine(x + 3, y - 4, x + 3, y + 4);
                gc.drawLine(x + 4, y - 3, x + 4, y + 3);
                gc.drawLine(x + 5, y - 2, x + 5, y + 2);
                gc.drawLine(x + 6, y - 1, x + 6, y + 1);
                break;
            }
            case 16384: {
                gc.drawLine(x - 3, y - 4, x - 3, y + 4);
                gc.drawLine(x - 4, y - 3, x - 4, y + 3);
                gc.drawLine(x - 5, y - 2, x - 5, y + 2);
                gc.drawLine(x - 6, y - 1, x - 6, y + 1);
                break;
            }
        }
    }

    public void drawLockedDateRangeMarker(GanttComposite ganttComposite, ISettings settings, IColorManager colorManager, GanttEvent ge, GC gc, boolean threeDee, int dayWidth, int y, int startLoc, int end, Rectangle bounds) {
        int start = startLoc;
        int maxY = settings.getEventHeight();
        int topY = y - 2;
        int xEnd = end;
        gc.setForeground(ColorCache.getColor(188, 188, 188));
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        int extra = dayWidth;
        if (ganttComposite.getCurrentView() == 1) {
            extra = 0;
        }
        if (start != -1 && xEnd != -1) {
            if (start < 0) {
                start = -1;
            }
            if (xEnd > bounds.width) {
                xEnd = bounds.width + 1;
            }
            gc.drawRectangle(start - 1, topY, xEnd - start + extra + 2, maxY + 4);
        } else {
            if (start != -1) {
                gc.drawRectangle(start - 4, topY + 1, 2, 3 + maxY);
                gc.drawLine(start - 2, topY + 1, start + 5, topY + 1);
                gc.drawLine(start - 2, topY + 4 + maxY, start + 5, topY + 4 + maxY);
            }
            if (xEnd != -1) {
                gc.drawRectangle((xEnd += extra) + 2, topY + 1, 2, 3 + maxY);
                gc.drawLine(xEnd + 2, topY + 1, xEnd - 5, topY + 1);
                gc.drawLine(xEnd + 2, topY + 4 + maxY, xEnd - 5, topY + 4 + maxY);
            }
        }
    }
}

