/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Plugin;
import org.hibernate.SessionFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.ActualClassResolver;
import ru.ssa.cashadmin.SessionFactoryBuilderAll;
import ru.ssa.cashadmin.SessionFactoryBuilderCategory;
import ru.ssa.cashadmin.SessionFactoryBuilderDic;
import ru.ssa.cashadmin.SessionFactoryBuilderDoc;
import ru.ssa.cashadmin.dao.DaoFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.yuki.bundle.ServiceUtils;

public class LibActivator
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LibActivator.class);
    private static LibActivator plugin;
    private BundleContext context;
    private Integer dictionaryVersion = 0;
    private Integer documentVersion = 0;
    private ActualClassResolver localResolver = new ActualClassResolver();
    public static final int NO_SHOP_LABEL_VERSION = 10;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log.info("starting cashadminlib");
        this.context = context;
        log.info("started cashadminlib");
    }

    public void startSilent() throws Exception {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static LibActivator getDefault() {
        return plugin;
    }

    public void initializeDictionary(String auditUser, Integer dictionaryVersion) {
        log.info("initializing dictionary dao factoris");
        this.dictionaryVersion = dictionaryVersion;
        DataSource dataSource = this.getBeanByClass(DataSource.class, "dataSource");
        Map.Entry<SessionFactory, Map<Class<?>, Boolean>> pair = new SessionFactoryBuilderDic(this.localResolver).programmatic(ArtixAdminContextHolder.isCashserver(), dataSource, auditUser, dictionaryVersion);
        DaoFactory.setSessionFactoryExternal(pair.getKey(), pair.getValue());
    }

    public void initializeDictionaryAll(String auditUser, Integer dictionaryVersion) {
        boolean cashserver = ArtixAdminContextHolder.isCashserver();
        if (cashserver) {
            log.info("initializing dictionaryAll dao factoris");
            DataSource dataSource = this.getBeanByClass(DataSource.class, "dataSourceDBAll");
            Map.Entry<SessionFactory, Map<Class<?>, Boolean>> pair = new SessionFactoryBuilderAll(this.localResolver).programmatic(cashserver, dataSource, auditUser, dictionaryVersion);
            DaoFactory.setSessionFactoryDBAll(pair.getKey(), pair.getValue());
        }
    }

    public void initializeDictionaryCategory(String auditUser, Integer dictionaryVersion) {
        boolean cashserver = ArtixAdminContextHolder.isCashserver();
        String defaultCategory = System.getProperty("yuki.discount_default_store");
        if (cashserver && StringUtils.isNotEmpty((String)defaultCategory)) {
            log.info("initializing dictionaryCategory dao factoris");
            DataSource dataSource = this.getBeanByClass(DataSource.class, "dataSourceCategory");
            Map.Entry<SessionFactory, Map<Class<?>, Boolean>> pair = new SessionFactoryBuilderCategory(this.localResolver).programmatic(cashserver, dataSource, auditUser, dictionaryVersion);
            DaoFactory.setSessionFactoryCategory(pair.getKey(), pair.getValue());
        }
    }

    public void initializeDocument(String auditUser, Integer documentVersion) {
        log.info("initializing document dao factoris");
        this.documentVersion = documentVersion;
        DataSource dataSource = this.getBeanByClass(DataSource.class, "documentsDataSource");
        Map.Entry<SessionFactory, Map<Class<?>, Boolean>> pair = new SessionFactoryBuilderDoc(this.localResolver).programmatic(ArtixAdminContextHolder.isCashserver(), dataSource, auditUser, documentVersion);
        DaoFactory.setSessionFactoryDocuments(pair.getKey(), pair.getValue());
    }

    public void clearModels() {
        DaoFactory.clearModels();
        log.info("initialized dao factoris");
    }

    public <T> T getBeanByClass(Class<T> clazz) {
        return ServiceUtils.getBeanByClass(this.context, clazz);
    }

    public <T> T getBeanByClass(Class<T> clazz, String beanName) {
        return ServiceUtils.getBeanByClass(this.context, clazz, beanName);
    }

    public ActualClassResolver getActualClassResolver() {
        return this.localResolver;
    }

    public Integer getDictionaryVersion() {
        return this.dictionaryVersion;
    }

    public Integer getDocumentVersion() {
        return this.documentVersion;
    }

    public void setLocalResolver(ActualClassResolver localResolver) {
        this.localResolver = localResolver;
    }
}

