/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.annotations.reflection.EJB3ReflectionManager;
import org.hibernate.event.LoadEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.ActualClassResolver;
import ru.ssa.cashadmin.AuditListener;
import ru.ssa.cashadmin.InjectionSettingsFactory;
import ru.ssa.cashadmin.SkipZeroKeyListener;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;

public abstract class SessionFactoryBuilder {
    private static final int FIRST_VERSION = 29;
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryBuilder.class);
    public static boolean showSql = Boolean.getBoolean("yuki.show_sql");
    private boolean saveDiscountAudit = !Boolean.getBoolean("yuki.did_not_save_discount_audit");
    private final ActualClassResolver localResolver;
    private Map<Class<?>, Boolean> map = new HashMap();
    private SkipZeroKeyListener skipZeroKeyListener;

    public SessionFactoryBuilder(ActualClassResolver localResolver) {
        this.localResolver = localResolver;
        this.skipZeroKeyListener = new SkipZeroKeyListener();
    }

    protected AnnotationConfiguration createConfiguration(DataSource dataSource, Properties extraProperties, Interceptor interceptor) {
        InjectionSettingsFactory settingsFactory = new InjectionSettingsFactory();
        HashMap<String, DataSource> map = new HashMap<String, DataSource>();
        map.put("dataSource", dataSource);
        settingsFactory.setConnectionProviderInjectionData(map);
        AnnotationConfiguration configuration = new AnnotationConfiguration((SettingsFactory)settingsFactory);
        this.setReflectionManager(configuration);
        Properties properties = this.getProperties();
        configuration.addProperties(properties);
        if (extraProperties != null) {
            configuration.addProperties(extraProperties);
        }
        configuration.setProperty("hibernate.connection.provider_class", "org.hibernate.ejb.connection.InjectedDataSourceConnectionProvider");
        if (ArtixAdminContextHolder.isCashserver() && this.saveDiscountAudit) {
            configuration.setListener("post-insert", "org.hibernate.ejb.event.EJB3PostInsertEventListener");
            configuration.setListener("post-insert", "org.hibernate.envers.event.EnversAuditEventListener");
            configuration.setListener("post-update", "org.hibernate.ejb.event.EJB3PostUpdateEventListener");
            configuration.setListener("post-update", "org.hibernate.envers.event.EnversAuditEventListener");
            configuration.setListener("post-delete", "org.hibernate.ejb.event.EJB3PostDeleteEventListener");
            configuration.setListener("post-delete", "org.hibernate.envers.event.EnversAuditEventListener");
            configuration.setListener("pre-collection-update", "org.hibernate.envers.event.EnversAuditEventListener");
            configuration.setListener("pre-collection-remove", "org.hibernate.envers.event.EnversAuditEventListener");
            configuration.setListener("post-collection-recreate", "org.hibernate.envers.event.EnversAuditEventListener");
        }
        if (interceptor != null) {
            configuration.setInterceptor(interceptor);
        }
        return configuration;
    }

    private void setReflectionManager(AnnotationConfiguration configuration) {
        try {
            log.trace("class={}", configuration.getClass());
            Field f = configuration.getClass().getDeclaredField("reflectionManager");
            f.setAccessible(true);
            f.set(configuration, new EJB3ReflectionManager(){

                public XClass toXClass(Class clazz) {
                    Class result = SessionFactoryBuilder.this.localResolver.getActual(clazz);
                    log.trace("result={}", result);
                    return super.toXClass(result);
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setListeners(AnnotationConfiguration configuration, String auditUser) {
        AuditListener listener = new AuditListener(auditUser);
        configuration.setListeners("save-update", ArrayUtils.add((Object[])ArrayUtils.add((Object[])configuration.getEventListeners().getSaveOrUpdateEventListeners(), (Object)listener), (Object)((Object)this.skipZeroKeyListener)));
        configuration.setListeners("create", ArrayUtils.add((Object[])configuration.getEventListeners().getPersistEventListeners(), (Object)listener));
        configuration.setListeners("delete", ArrayUtils.add((Object[])configuration.getEventListeners().getDeleteEventListeners(), (Object)listener));
        configuration.setListeners("save", ArrayUtils.add((Object[])ArrayUtils.add((Object[])configuration.getEventListeners().getSaveEventListeners(), (Object)listener), (Object)((Object)this.skipZeroKeyListener)));
        log.info("load lis={}", Arrays.asList(configuration.getEventListeners().getLoadEventListeners()));
        configuration.setListeners("load", (Object[])new LoadEventListener[]{this.skipZeroKeyListener});
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", "org.hibernate.dialect.MySQLDialect");
        properties.put("hibernate.connection.autoReconnect", "true");
        properties.put("hibernate.jdbc.batch_versioned_data", "true");
        properties.put("hibernate.current_session_context_class", "thread");
        if (showSql) {
            properties.put("hibernate.show_sql", "true");
        } else {
            properties.put("hibernate.show_sql", "false");
        }
        properties.put("hibernate.format_sql", "true");
        properties.put("hibernate.c3p0.max_size", "10");
        properties.put("hibernate.c3p0.min_size", "1");
        properties.put("hibernate.c3p0.timeout", "300");
        properties.put("hibernate.c3p0.acquireIncrement", "2");
        return properties;
    }

    public static Class<?> findClass(Class<?> base, Integer version, Boolean isCashserver) {
        String className;
        int i;
        if (isCashserver.booleanValue()) {
            i = version;
            while (i >= 0) {
                className = String.valueOf(base.getName()) + "Server" + (i == 0 ? "" : "V" + i);
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.trace("class for server not found={}", (Object)className);
                    --i;
                }
            }
        }
        i = version;
        while (i > 29) {
            className = String.valueOf(base.getName()) + "V" + i;
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.trace("class not found={}", (Object)className);
                --i;
            }
        }
        return base;
    }

    protected void initClasses(AnnotationConfiguration configuration, Boolean isCashserver, Integer version) {
        for (Class<?> cl : this.map.keySet()) {
            Class<?> result = SessionFactoryBuilder.findClass(cl, version, isCashserver);
            configuration.addAnnotatedClass(result);
            this.localResolver.putActual(cl, result);
        }
    }

    protected void addClass(Class<?> cl, boolean thisSession) {
        this.map.put(cl, thisSession);
    }

    protected void addClass(Class<?> cl) {
        this.addClass(cl, true);
    }

    public Map.Entry<SessionFactory, Map<Class<?>, Boolean>> programmatic(Boolean isCashserver, DataSource dataSource, String auditUser, Integer version) {
        return this.programmatic(isCashserver, dataSource, null, null, auditUser, version);
    }

    public Map.Entry<SessionFactory, Map<Class<?>, Boolean>> programmatic(Boolean isCashserver, DataSource dataSource, Properties extraProperties, Interceptor interceptor, String auditUser, Integer version) {
        try {
            AnnotationConfiguration configuration = this.createConfiguration(dataSource, extraProperties, interceptor);
            this.setListeners(configuration, auditUser);
            this.addClasses(configuration, isCashserver, version);
            return new AbstractMap.SimpleEntry(configuration.buildSessionFactory(), this.map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void addClasses(AnnotationConfiguration configuration, Boolean isCashserver, Integer version) {
    }
}

