/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.NotEmpty;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.Units;

@Entity
@Table(name="barcodes")
@MappedSuperclass
public class Barcodes
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @NotEmpty
    @Size(max=100)
    @Column(name="code", insertable=false, updatable=false)
    private String code;
    @NotNull
    @NotEmpty
    @Size(max=100)
    @Id
    private String barcode;
    @Size(max=200)
    private String name;
    @Min(value=0L)
    @Digits(integer=15, fraction=2)
    private BigDecimal price;
    @Min(value=0L)
    @Digits(integer=13, fraction=3)
    private BigDecimal cquant;
    @ManyToOne
    @JoinColumn(name="measure")
    @NotFound(action=NotFoundAction.IGNORE)
    private Units measure;
    @Column(name="measure", insertable=false, updatable=false)
    private Integer measurecode;
    @NotNull
    @ManyToOne
    @JoinColumn(name="code")
    @NotFound(action=NotFoundAction.IGNORE)
    private Invent invent;
    @Column(name="code", insertable=false, updatable=false)
    private String inventcode;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getCquant() {
        return this.cquant;
    }

    public void setCquant(BigDecimal cquant) {
        this.cquant = cquant;
    }

    public Units getMeasure() {
        return this.measure;
    }

    public void setMeasure(Units measure) {
        this.measure = measure;
        this.measurecode = measure != null ? measure.getCode() : null;
    }

    public Integer getMeasurecode() {
        return this.measurecode;
    }

    public void setMeasurecode(Integer measurecode) {
        this.measurecode = measurecode;
    }

    public Invent getInvent() {
        return this.invent;
    }

    public void setInvent(Invent invent) {
        this.invent = invent;
        this.code = invent != null ? invent.getBcode() : null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.barcode == null ? 0 : this.barcode.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.cquant == null ? 0 : this.cquant.hashCode());
        result = 31 * result + (this.measurecode == null ? 0 : this.measurecode.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Barcodes other = (Barcodes)obj;
        if (this.barcode == null ? other.barcode != null : !this.barcode.equals(other.barcode)) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.cquant == null ? other.cquant != null : !this.cquant.equals(other.cquant)) {
            return false;
        }
        if (this.measurecode == null ? other.measurecode != null : !this.measurecode.equals(other.measurecode)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.price == null ? other.price != null : !this.price.equals(other.price));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Barcodes [code=");
        builder.append(this.code);
        builder.append(", barcode=");
        builder.append(this.barcode);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", price=");
        builder.append(this.price);
        builder.append(", cquant=");
        builder.append(this.cquant);
        builder.append(", measure=");
        builder.append(this.measure);
        builder.append("]");
        return builder.toString();
    }

    public String getInventcode() {
        return this.inventcode;
    }

    public void setInventcode(String inventcode) {
        this.inventcode = inventcode;
    }

    public void initDefault() {
    }
}

