/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.io.File;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Catalog;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.view.Base64ImageExtractor;

@SecurityKey(title="\u041a\u0430\u0442\u0430\u043b\u043e\u0433\u0438")
public class PicklistCatalogEditPanel
extends EditorComposite<Catalog> {
    private static final Logger log = LoggerFactory.getLogger(PicklistCatalogEditPanel.class);
    @SecurityKey(title="\u041a\u043e\u0434", id="catalogid")
    private Label codeLabel;
    @SecurityKey(id="catalogid")
    @BindingKey(autoChanged=true, bindingType=BindingType.STRING)
    private Spinner codeField;
    @SecurityKey(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", id="catalogname")
    private Label nameLabel;
    @SecurityKey(id="catalogname")
    private Text nameField;
    @SecurityKey(title="\u0418\u0437\u043e\u0431\u0430\u0440\u0436\u0435\u043d\u0438\u0435", id="image")
    private Label imageLabel;
    @SecurityKey(id="image")
    @BindingKey(bindingType=BindingType.IMAGE)
    private Label imageField;

    public PicklistCatalogEditPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public PicklistCatalogEditPanel(Composite parent, int style, Catalog model) {
        super(parent, style, Catalog.class, (Object)model);
    }

    public void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.codeLabel = new Label((Composite)this, 0);
        this.codeLabel.setText("\u041a\u043e\u0434:");
        this.codeField = new Spinner((Composite)this, 2048);
        this.codeField.setMaximum(Integer.MAX_VALUE);
        this.codeField.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:");
        this.nameField = new Text((Composite)this, 2048);
        this.nameField.setLayoutData((Object)new GridData(4, 0, true, false));
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setText("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435:");
        Button button = new Button((Composite)this, 8);
        button.setText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c  \u0444\u0430\u0439\u043b (\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 48\u043a\u0431) ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = PicklistCatalogEditPanel.openDialogsForSelectImage((Shell)PicklistCatalogEditPanel.this.getShell());
                if (path != null) {
                    try {
                        String data = DatatypeConverter.printBase64Binary((byte[])FileUtils.readFileToByteArray((File)new File(path)));
                        ((Catalog)PicklistCatalogEditPanel.this.getModel()).setImage(data);
                        PicklistCatalogEditPanel.this.imageField.setImage(new Base64ImageExtractor().getImage(data));
                        PicklistCatalogEditPanel.this.imageField.pack();
                        PicklistCatalogEditPanel.this.imageField.redraw();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        new Label((Composite)this, 0);
        this.imageField = new Label((Composite)this, 0);
        this.imageField.setSize(new Point(500, 500));
        this.setLayout((Layout)gridLayout);
    }

    public void initDefault(Catalog model) {
        super.initDefault((Object)model);
        model.setType(Integer.valueOf(1));
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public void switchID() {
        if (this.autoChangedValue != null) {
            this.autoChangedValue.setValue((Object)Integer.valueOf((String)this.getDirectoryModel().getNextId()));
        }
    }
}

