/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.action;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Macroparameters;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.provider.LazyContentProvider;

class UpAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(UpAction.class);
    private Macroparameters model;
    private TableViewer tableViewer;

    private UpAction() {
        super("\u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u043f\u043e\u0440\u044f\u0434\u043e\u043a");
        this.setToolTipText("\u0423\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u0435 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430");
        this.setEnabled(true);
    }

    public UpAction(TableViewer tableViewer, ImageDescriptor imageDescriptor) {
        this();
        this.tableViewer = tableViewer;
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        try {
            this.model = (Macroparameters)((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            if (this.model != null && this.model.getMacro() != null) {
                Macroparameters filter = (Macroparameters)LibActivator.getDefault().getActualClassResolver().getInstance(Macroparameters.class);
                filter.setMacro(this.model.getMacro());
                DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Macroparameters.class);
                List macroparamters = directoryModel.getList((Object)filter);
                Collections.sort(macroparamters, new Comparator<Macroparameters>(){

                    @Override
                    public int compare(Macroparameters o1, Macroparameters o2) {
                        return o1.getMacroparameterorder().compareTo(o2.getMacroparameterorder());
                    }
                });
                int upIndex = macroparamters.indexOf(this.model);
                if (upIndex > 0) {
                    int order = this.model.getMacroparameterorder();
                    Macroparameters upModel = this.model;
                    while (order == this.model.getMacroparameterorder() && upIndex > 0) {
                        upModel = (Macroparameters)macroparamters.get(--upIndex);
                        order = upModel.getMacroparameterorder();
                    }
                    upModel.setMacroparameterorder(this.model.getMacroparameterorder());
                    this.model.setMacroparameterorder(Integer.valueOf(order));
                    directoryModel.doUpdate((Object)this.model);
                    directoryModel.doUpdate((Object)upModel);
                    directoryModel.doRefresh();
                    ((LazyContentProvider)this.tableViewer.getContentProvider()).disposeCash();
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)upModel), true);
                }
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

