/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashadmin.splashHandlers;

import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.action.connect.ConnectAction;
import ru.ssa.artixadmin.editors.connect.ConnectDialog;
import ru.ssa.artixadmin.editors.connect.EditConnectXmlFile;
import ru.ssa.artixadmin.editors.connect.OptionalBundleStart;
import ru.ssa.artixadmin.provider.connect.ConnectLabelProvider;
import ru.ssa.cashadmin.domain.Connect;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.yuki.images.ArtixAdminImages;

public class InteractiveSplashHandler
extends AbstractSplashHandler {
    private static final Logger log = LoggerFactory.getLogger(InteractiveSplashHandler.class);
    private Composite fCompositeConnect = null;
    private Composite buttonsComposite;
    private TableComboViewer connectionsViewer;
    private Button buttonEditConnect;
    private Button fButtonOK = null;
    private Button fButtonCancel = null;
    private boolean fAuthenticated = false;
    private int loginStatus = -1;
    private List<Connect> connections;
    private Composite progressComposite;
    private ProgressBar progressBar;
    private Connect selected;

    public void init(Shell splash) {
        super.init(splash);
        this.configureUISplash();
        this.createUI();
        this.createUIListeners();
        splash.layout(true);
        boolean silentSelect = Boolean.getBoolean("yuki.silent_select");
        if (silentSelect) {
            this.toggelCheckProgress(true);
            int selectedIndex = Integer.getInteger("yuki.silent_select_value", 0);
            log.info("silent select connection, index={}", (Object)selectedIndex);
            boolean succefull = this.connect(this.connections.get(selectedIndex));
            if (succefull) {
                log.info("silent connection succefull");
                this.loginStatus = 1;
            }
        }
        this.doEventLoop();
    }

    public IProgressMonitor getBundleProgressMonitor() {
        return new NullProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                InteractiveSplashHandler.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (InteractiveSplashHandler.this.progressBar != null) {
                            InteractiveSplashHandler.this.progressBar.setSelection(70);
                        }
                    }
                });
            }

            public void subTask(String name) {
                InteractiveSplashHandler.this.getSplash().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (InteractiveSplashHandler.this.progressBar != null && InteractiveSplashHandler.this.progressBar.getSelection() < 100) {
                            InteractiveSplashHandler.this.progressBar.setSelection(InteractiveSplashHandler.this.progressBar.getSelection() + 14);
                        }
                    }
                });
            }
        };
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        while (!this.fAuthenticated) {
            if (splash.getDisplay().readAndDispatch()) continue;
            if (this.loginStatus == 1) {
                this.loginSuccess();
            } else if (this.loginStatus == 2) {
                this.loginFailure();
            }
            splash.getDisplay().sleep();
        }
    }

    private void loginSuccess() {
        this.fCompositeConnect.setVisible(false);
        this.fAuthenticated = true;
        this.loginStatus = -1;
    }

    private void loginFailure() {
        this.toggelCheckProgress(false);
        this.loginStatus = -1;
    }

    private void createUIListeners() {
        this.createUIListenersButtonOK();
        this.createUIListenersButtonCancel();
    }

    private void createUIListenersButtonCancel() {
        this.fButtonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonCancelWidgetSelected();
            }
        });
    }

    private void handleButtonCancelWidgetSelected() {
        this.getSplash().getDisplay().close();
        System.exit(0);
    }

    private void createUIListenersButtonOK() {
        this.fButtonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonOKWidgetSelected();
            }
        });
    }

    private void handleButtonOKWidgetSelected() {
        boolean succefull;
        this.toggelCheckProgress(true);
        Connect connect = this.getClone(this.selected);
        String inputText = this.connectionsViewer.getTableCombo().getText().trim();
        if (!connect.getName().equals(inputText)) {
            log.debug("user input text:{} not equals selected connection name:{}. Use input text as address.", (Object)inputText, (Object)connect.getName());
            connect.setAddress(inputText);
        }
        if ((succefull = this.connect(connect)) && !connect.isCurrent()) {
            for (Connect conn : this.connections) {
                conn.setCurrent(false);
            }
            this.selected.setCurrent(true);
            EditConnectXmlFile.saveConnections(this.connections);
        }
        this.loginStatus = succefull ? 1 : 2;
    }

    private boolean connect(Connect connect) {
        ArtixAdminContextHolder.setCashserver((boolean)connect.isCashServerConnect());
        OptionalBundleStart.startBundles(connect.isCashServerConnect(), connect.getCsVersion());
        ConnectAction action = new ConnectAction(connect, connect.isCashServerConnect(), this.progressBar);
        boolean succefull = action.run();
        return succefull;
    }

    private Connect getClone(Connect selected) {
        try {
            return (Connect)BeanUtils.cloneBean((Object)selected);
        }
        catch (Exception e) {
            log.error("Couldn't clone. Use base connect.", (Throwable)e);
            return selected;
        }
    }

    private void createUI() {
        this.createUIComposite();
        this.createUITextUserName();
        this.createUICompositeButton();
        this.createUIButtonOK();
        this.createUIButtonCancel();
        this.createProgressInfo();
    }

    private void createProgressInfo() {
        this.progressBar = new ProgressBar(this.progressComposite, 256);
        this.progressBar.setMaximum(100);
        this.progressBar.setVisible(false);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.progressBar);
    }

    private void toggelCheckProgress(boolean state) {
        this.progressBar.setVisible(state);
        this.progressBar.setSelection(state ? 1 : 0);
        this.progressComposite.layout();
    }

    private void createUICompositeButton() {
        this.buttonsComposite = new Composite(this.fCompositeConnect, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).equalWidth(true).numColumns(2).applyTo(this.buttonsComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.buttonsComposite);
    }

    private void createUIButtonCancel() {
        this.fButtonCancel = new Button(this.buttonsComposite, 8);
        this.fButtonCancel.setText("\u0412\u044b\u0445\u043e\u0434");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fButtonCancel);
    }

    private void createUIButtonOK() {
        this.fButtonOK = new Button(this.buttonsComposite, 8);
        this.fButtonOK.setText("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f");
        this.fButtonOK.setFocus();
        this.fButtonOK.setEnabled(!this.connections.isEmpty());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fButtonOK);
    }

    private List<Connect> getConnections() {
        List<Connect> allConnections = EditConnectXmlFile.readAllConnections();
        return allConnections;
    }

    private void refrashComboConnections(Connect selectElement) {
        if (this.connections == null || this.connections.isEmpty()) {
            this.connections = this.getConnections();
        }
        Connect lastConnectSelection = null;
        if (!this.connectionsViewer.getSelection().isEmpty()) {
            lastConnectSelection = (Connect)((IStructuredSelection)this.connectionsViewer.getSelection()).getFirstElement();
        }
        this.connectionsViewer.setInput(this.connections);
        if (!this.connections.isEmpty()) {
            if (selectElement != null && this.connections.contains(selectElement)) {
                this.connectionsViewer.setSelection((ISelection)new StructuredSelection((Object)selectElement));
            } else if (lastConnectSelection != null && this.connections.contains(lastConnectSelection)) {
                this.connectionsViewer.setSelection((ISelection)new StructuredSelection((Object)lastConnectSelection));
            } else {
                boolean selected = false;
                for (Connect connect : this.connections) {
                    if (!connect.isCurrent()) continue;
                    this.connectionsViewer.setSelection((ISelection)new StructuredSelection((Object)connect));
                    selected = true;
                    break;
                }
                if (!selected) {
                    this.connectionsViewer.setSelection((ISelection)new StructuredSelection((Object)this.connections.get(0)));
                }
            }
            if (this.fButtonOK != null) {
                this.fButtonOK.setEnabled(true);
            }
        } else if (this.fButtonOK != null) {
            this.fButtonOK.setEnabled(false);
        }
    }

    private void createUITextUserName() {
        this.connectionsViewer = new TableComboViewer(this.fCompositeConnect, 2048);
        this.connectionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectionsViewer.setLabelProvider((IBaseLabelProvider)new ConnectLabelProvider());
        this.connectionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object first = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (first != null) {
                    InteractiveSplashHandler.this.selected = (Connect)first;
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.connectionsViewer.getTableCombo());
        this.refrashComboConnections(null);
        boolean isDisabledEditConnect = Boolean.getBoolean("yuki.button_edit_connect.disabled");
        this.buttonEditConnect = new Button(this.fCompositeConnect, 8);
        this.buttonEditConnect.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
        this.buttonEditConnect.setFont(JFaceResources.getDialogFont());
        this.buttonEditConnect.setEnabled(!isDisabledEditConnect);
        this.buttonEditConnect.setImage(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit").createImage());
        this.buttonEditConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectDialog connectDialog = new ConnectDialog(InteractiveSplashHandler.this.getConnections());
                if (connectDialog.open() == 0) {
                    InteractiveSplashHandler.this.connections = connectDialog.getConnections();
                    InteractiveSplashHandler.this.refrashComboConnections(connectDialog.getConnect());
                } else {
                    InteractiveSplashHandler.this.connections = connectDialog.getConnections();
                    InteractiveSplashHandler.this.refrashComboConnections(null);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.buttonEditConnect);
    }

    private void createUIComposite() {
        Composite main = new Composite((Composite)this.getSplash(), 0);
        GridLayoutFactory.swtDefaults().spacing(0, 0).margins(5, 0).equalWidth(true).numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Composite temp = new Composite(main, 0);
        GridLayoutFactory.swtDefaults().applyTo(temp);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)temp);
        Composite temp1 = new Composite(main, 0);
        GridLayoutFactory.swtDefaults().applyTo(temp1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)temp1);
        this.fCompositeConnect = new Composite(main, 2048);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fCompositeConnect);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fCompositeConnect);
        this.progressComposite = new Composite(main, 0);
        GridLayoutFactory.swtDefaults().margins(5, 0).applyTo(this.progressComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.progressComposite);
    }

    private void configureUISplash() {
        FillLayout layout = new FillLayout();
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }
}

