/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.GuiElementController;
import su.artix.discountmanager.Activator;
import su.artix.loyaltylib.domain.java.observable.Named;
import su.artix.yuki.editors.DialogMode;

public class SystemTitleAreaDialog
extends TitleAreaDialog {
    private static final Logger log = LoggerFactory.getLogger(SystemTitleAreaDialog.class);
    private DialogMode dialogMode;
    protected final Map<String, String> paramList;

    public SystemTitleAreaDialog(Shell parentShell) {
        this(parentShell, DialogMode.UNKNOWN, null);
    }

    public SystemTitleAreaDialog(Shell parentShell, DialogMode dialogMode, Map<String, String> params) {
        super(parentShell);
        this.paramList = params;
        this.dialogMode = dialogMode;
        this.setShellStyle(65648);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().applyTo(content);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)content);
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        return content;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        String selector = null;
        if (this.paramList != null && !this.paramList.isEmpty()) {
            selector = this.paramList.get("viewId");
        }
        log.debug("selector ={}", selector);
        this.applyRights(selector);
        return control;
    }

    protected void fillTitleHeader(Named parent, Named current) {
        log.trace("params:{}", this.paramList);
        this.setTitleDialog(this.paramList.get("title"));
        StringBuilder string = new StringBuilder();
        if (parent != null) {
            string.append("> ");
            if (parent.getName() != null) {
                string.append(parent.getName());
                string.append(" > ");
            }
        }
        this.setMessage(String.valueOf(string.toString()) + StringUtils.defaultIfEmpty((String)current.getName(), (String)"..."));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void applyRights(String selector) {
        Activator.getDefault().getBeanByClass(GuiElementController.class).applyRights(((Object)((Object)this)).getClass(), (Object)this, selector);
    }

    public String getTitleDialog() {
        return this.getShell().getText();
    }

    public void setTitleDialog(String titleDialog) {
        this.getShell().setText(titleDialog);
    }

    public DialogMode getDialogMode() {
        return this.dialogMode;
    }

    protected boolean isResizable() {
        return true;
    }
}

