/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.calculator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.calculator.CalculatorEngine;
import org.mihalis.opal.utils.SWTGraphicUtil;

class CalculatorButtonsComposite
extends Composite {
    private static final String LABEL_C = "C";
    private static final String LABEL_CE = "CE";
    private static final String LABEL_BACK = "Back";
    private final Color darkRedColor;
    private final Color darkBlueColor;
    private final CalculatorEngine engine;
    private Label displayArea;
    private KeyListener keyListener;
    private final List<ModifyListener> modifyListeners;

    CalculatorButtonsComposite(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(5, false));
        this.darkRedColor = new Color((Device)this.getDisplay(), 139, 0, 0);
        this.darkBlueColor = new Color((Device)this.getDisplay(), 0, 0, 139);
        this.createButtons();
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.darkBlueColor);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.darkRedColor);
        this.engine = new CalculatorEngine(this);
        this.addKeyListeners();
        this.modifyListeners = new ArrayList<ModifyListener>();
    }

    private void createButtons() {
        Button button = this.createButton(LABEL_BACK, this.darkRedColor);
        button.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processBackSpace();
            }
        });
        Button button2 = this.createButton(LABEL_CE, this.darkRedColor);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.clearResult();
            }
        });
        Button button3 = this.createButton(LABEL_C, this.darkRedColor);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.clearWholeContent();
            }
        });
        this.createDigitButton(7);
        this.createDigitButton(8);
        this.createDigitButton(9);
        Button button4 = this.createButton("/", this.getDisplay().getSystemColor(3));
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processOperation("/");
            }
        });
        Button button5 = this.createButton("\u221a", this.darkRedColor);
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processSquareRootOperation();
            }
        });
        this.createDigitButton(4);
        this.createDigitButton(5);
        this.createDigitButton(6);
        Button button6 = this.createButton("*", this.getDisplay().getSystemColor(3));
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processOperation("*");
            }
        });
        Button button7 = this.createButton("1/x", this.darkBlueColor);
        button7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processInverseOperation();
            }
        });
        this.createDigitButton(1);
        this.createDigitButton(2);
        this.createDigitButton(3);
        Button button8 = this.createButton("-", this.getDisplay().getSystemColor(3));
        button8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processOperation("-");
            }
        });
        Button button9 = this.createButton("%", this.darkBlueColor);
        button9.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processPerCentageOperation();
            }
        });
        this.createDigitButton(0);
        Button button10 = this.createButton("+/-", this.getDisplay().getSystemColor(9));
        button10.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processSignChange();
            }
        });
        Button button11 = this.createButton(".", this.getDisplay().getSystemColor(9));
        button11.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.addDecimalPoint();
            }
        });
        Button button12 = this.createButton("+", this.getDisplay().getSystemColor(3));
        button12.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processOperation("+");
            }
        });
        Button button13 = this.createButton("=", this.getDisplay().getSystemColor(3));
        button13.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.processEquals();
            }
        });
    }

    private void createDigitButton(final int n) {
        Button button = this.createButton(" " + n + " ", this.getDisplay().getSystemColor(9));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsComposite.this.engine.addDigitToDisplay(n);
            }
        });
    }

    private Button createButton(final String string, final Color color) {
        final Button button = new Button((Composite)this, 0x20000008);
        button.setText("");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 30;
        button.setLayoutData((Object)gridData);
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.setForeground(color);
                paintEvent.gc.setFont(CalculatorButtonsComposite.this.getFont());
                Point point = paintEvent.gc.textExtent(" " + string + " ", 0x40000000);
                paintEvent.gc.drawText(" " + string + " ", (button.getBounds().width - point.x) / 2, (button.getBounds().height - point.y) / 2, true);
            }
        });
        return button;
    }

    private void addKeyListeners() {
        this.keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.character) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        CalculatorButtonsComposite.this.engine.addDigitToDisplay(Integer.parseInt(String.valueOf(keyEvent.character)));
                        return;
                    }
                    case '.': {
                        CalculatorButtonsComposite.this.engine.addDecimalPoint();
                        return;
                    }
                    case '+': {
                        CalculatorButtonsComposite.this.engine.processOperation("+");
                        return;
                    }
                    case '-': {
                        CalculatorButtonsComposite.this.engine.processOperation("-");
                        return;
                    }
                    case '*': {
                        CalculatorButtonsComposite.this.engine.processOperation("*");
                        return;
                    }
                    case '/': {
                        CalculatorButtonsComposite.this.engine.processOperation("/");
                        return;
                    }
                    case '=': {
                        CalculatorButtonsComposite.this.engine.processEquals();
                        return;
                    }
                    case '%': {
                        CalculatorButtonsComposite.this.engine.processPerCentageOperation();
                        return;
                    }
                }
                switch (keyEvent.keyCode) {
                    case 0x1000030: 
                    case 0x1000031: 
                    case 16777266: 
                    case 0x1000033: 
                    case 16777268: 
                    case 16777269: 
                    case 16777270: 
                    case 16777271: 
                    case 16777272: 
                    case 16777273: {
                        int n = keyEvent.keyCode - 0x1000000 - 47;
                        CalculatorButtonsComposite.this.engine.addDigitToDisplay(n);
                        return;
                    }
                    case 16777259: {
                        CalculatorButtonsComposite.this.engine.processOperation("+");
                        return;
                    }
                    case 16777261: {
                        CalculatorButtonsComposite.this.engine.processOperation("-");
                        return;
                    }
                    case 16777263: {
                        CalculatorButtonsComposite.this.engine.processOperation("/");
                        return;
                    }
                    case 16777258: {
                        CalculatorButtonsComposite.this.engine.processOperation("*");
                        return;
                    }
                    case 13: 
                    case 16777277: 
                    case 0x1000050: {
                        CalculatorButtonsComposite.this.engine.processEquals();
                        return;
                    }
                    case 16777262: {
                        CalculatorButtonsComposite.this.engine.addDecimalPoint();
                        return;
                    }
                    case 8: {
                        CalculatorButtonsComposite.this.engine.processBackSpace();
                        return;
                    }
                    case 27: {
                        CalculatorButtonsComposite.this.engine.clearWholeContent();
                        return;
                    }
                }
            }
        };
        for (Control control : this.getChildren()) {
            control.addKeyListener(this.keyListener);
        }
        this.addKeyListener(this.keyListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.modifyListeners.add(modifyListener);
    }

    void fireModifyListeners() {
        for (ModifyListener modifyListener : this.modifyListeners) {
            Event event = new Event();
            event.widget = this;
            ModifyEvent modifyEvent = new ModifyEvent(event);
            modifyListener.modifyText(modifyEvent);
        }
    }

    KeyListener getKeyListener() {
        return this.keyListener;
    }

    Label getDisplayArea() {
        return this.displayArea;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.modifyListeners.remove(modifyListener);
    }

    void setDisplayArea(Label label) {
        this.displayArea = label;
    }
}

