/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation.validator;

import com.richclientgui.toolbox.Messages;
import com.richclientgui.toolbox.validation.ValidatingField;
import com.richclientgui.toolbox.validation.validator.IInputMaskValidator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractInputMaskValidator<T>
implements IInputMaskValidator<T> {
    protected static final String PUNCTUATIONS = ",.:;?!@#%&";
    protected static final String INVALID_VALUE = Messages.getString("AbstractInputMaskValidator.message.invalid.value");
    protected static final String INVALID_DIGIT_VALUE = Messages.getString("AbstractInputMaskValidator.message.invalid.value.digit");
    protected static final String INVALID_ALPHANUMERICAL_VALUE = Messages.getString("AbstractInputMaskValidator.message.invalid.value.alphanum");
    protected static final String INVALID_UPPERCASE_VALUE = Messages.getString("AbstractInputMaskValidator.message.invalid.value.uppercase");
    protected static final String INVALID_LOWERCASE_VALUE = Messages.getString("AbstractInputMaskValidator.message.invalid.value.lowercase");
    protected static final String INVALID_PUNCTUATION_VALUE = String.valueOf(Messages.getString("AbstractInputMaskValidator.message.invalid.value.punc")) + ",.:;?!@#%&";
    protected static final String INVALID_ALPHA_PUNC_VALUE = Messages.getString("AbstractInputMaskValidator.message.invalid.value.alphapunc");
    protected static final String INVALID_NONWHITESPACE = Messages.getString("AbstractInputMaskValidator.message.invalid.value.nonwhitespace");
    protected static final char CHAR_DIGIT = '#';
    protected static final char CHAR_ALPHANUMERICAL = 'A';
    protected static final char CHAR_UPPERCASE = 'U';
    protected static final char CHAR_LOWERCASE = 'L';
    protected static final char CHAR_DONTCARE = '*';
    protected static final char CHAR_PUNCTUATION = '.';
    protected static final char CHAR_ALPHA_PUNC = '_';
    protected static final char CHAR_SPACE = ' ';
    protected static final char CHAR_ZERO = '0';
    protected String maskPattern;
    protected StringBuffer inputValue;
    protected int maskEndPosition;
    protected int inputCharCount = 0;
    protected boolean ignoreVerify;
    protected ValidatingField<T> field;

    protected AbstractInputMaskValidator(String maskPattern) {
        if (maskPattern == null) {
            SWT.error((int)4);
        }
        this.maskPattern = maskPattern;
        this.initInputValue();
    }

    protected String getMaskPattern() {
        return this.maskPattern;
    }

    @Override
    public void install(ValidatingField<T> validatingField) {
        this.field = validatingField;
        if (this.field.getControl() instanceof Text) {
            Text text = (Text)this.field.getControl();
            text.setTextLimit(this.maskPattern.length());
            text.addVerifyListener((VerifyListener)this);
            this.updateText(this.inputValue.toString(), 0);
        } else if (this.field.getControl() instanceof Combo) {
            Combo combo = (Combo)this.field.getControl();
            combo.setTextLimit(this.maskPattern.length());
            combo.addVerifyListener((VerifyListener)this);
            this.updateText(this.inputValue.toString(), 0);
        } else if (this.field.getControl() instanceof CCombo) {
            CCombo combo = (CCombo)this.field.getControl();
            combo.setTextLimit(this.maskPattern.length());
            combo.addVerifyListener((VerifyListener)this);
            this.updateText(this.inputValue.toString(), 0);
        }
    }

    @Override
    public void uninstall() {
        if (this.field.getControl() instanceof Text) {
            ((Text)this.field.getControl()).removeVerifyListener((VerifyListener)this);
        } else if (this.field.getControl() instanceof Combo) {
            ((Combo)this.field.getControl()).removeVerifyListener((VerifyListener)this);
        } else if (this.field.getControl() instanceof CCombo) {
            ((CCombo)this.field.getControl()).removeVerifyListener((VerifyListener)this);
        }
    }

    protected static boolean isPatternChar(char c) {
        switch (c) {
            case '#': 
            case '*': 
            case '.': 
            case 'A': 
            case 'L': 
            case 'U': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    protected void initInputValue() {
        this.inputValue = new StringBuffer(this.maskPattern.length());
        int i = 0;
        while (i < this.maskPattern.length()) {
            char c = this.maskPattern.charAt(i);
            if (!AbstractInputMaskValidator.isPatternChar(c)) {
                this.inputValue.append(c);
            } else {
                this.inputValue.append(' ');
                ++this.maskEndPosition;
            }
            ++i;
        }
    }

    public void verifyText(VerifyEvent event) {
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        if (event.keyCode == 8 || event.keyCode == 127) {
            this.doClearText(event);
        } else {
            int position = this.doInsert(event);
            this.doUpdatePosition(position);
        }
    }

    private void doUpdatePosition(int position) {
        while (position < this.maskPattern.length() - 1 && !AbstractInputMaskValidator.isPatternChar(this.maskPattern.charAt(position))) {
            ++position;
        }
        this.updateText(this.inputValue.toString(), position);
    }

    private int doInsert(VerifyEvent event) {
        int position;
        block3: {
            position = 0;
            try {
                if (event.end - event.start > event.text.length()) {
                    this.clearText(event.start + event.text.length(), event.end - event.start - event.text.length());
                }
                position = this.insertText(event.text, event.start);
            }
            catch (IllegalArgumentException iae) {
                position = event.start;
                if (!this.mustIncreasePositionOnError() || position >= this.maskPattern.length() - 1) break block3;
                ++position;
            }
        }
        return position;
    }

    protected boolean mustIncreasePositionOnError() {
        return false;
    }

    private void doClearText(VerifyEvent e) {
        this.clearText(e.start, e.end > e.start ? e.end - e.start : 1);
        this.updateText(this.inputValue.toString(), e.start);
    }

    @Override
    public boolean isValid(T contents) {
        return (this.inputCharCount == 0 || this.inputCharCount == this.maskEndPosition) && this.isContentsValid(contents);
    }

    public abstract boolean isContentsValid(T var1);

    protected void updateText(String textString) {
        if (this.field.getControl() instanceof Text) {
            this.updateText(textString, ((Text)this.field.getControl()).getCaretPosition());
        } else if (this.field.getControl() instanceof Combo) {
            this.updateText(textString, ((Combo)this.field.getControl()).getSelection().x);
        } else if (this.field.getControl() instanceof CCombo) {
            this.updateText(textString, ((CCombo)this.field.getControl()).getSelection().x);
        }
    }

    protected void updateText(String textString, int position) {
        this.ignoreVerify = true;
        if (this.field.getControl() instanceof Text) {
            Text text = (Text)this.field.getControl();
            text.setText(textString);
            text.setSelection(position);
        } else if (this.field.getControl() instanceof Combo) {
            Combo combo = (Combo)this.field.getControl();
            combo.setText(textString);
            combo.setSelection(new Point(position, position));
        } else if (this.field.getControl() instanceof CCombo) {
            CCombo combo = (CCombo)this.field.getControl();
            combo.setText(textString);
            combo.setSelection(new Point(position, position));
        }
        this.ignoreVerify = false;
    }

    private static boolean isPunctuation(char c) {
        return PUNCTUATIONS.contains(String.valueOf(c));
    }

    protected int insertText(String textValue, int start) {
        int maskPos = start;
        int valuePos = 0;
        char maskChar = '\u0000';
        char valueChar = '\u0000';
        int inputValueChar = 0;
        block9: while (maskPos < this.maskPattern.length() && valuePos < textValue.length()) {
            maskChar = this.maskPattern.charAt(maskPos);
            valueChar = textValue.charAt(valuePos);
            inputValueChar = this.inputValue.charAt(maskPos);
            switch (maskChar) {
                case '#': {
                    this.handleDigit(maskPos, valueChar);
                    break;
                }
                case 'U': {
                    this.handleUppercaseLetter(maskPos, valueChar);
                    break;
                }
                case 'L': {
                    this.handleLowercaseLetter(maskPos, valueChar);
                    break;
                }
                case 'A': {
                    this.handleAlphaNumerical(maskPos, valueChar);
                    break;
                }
                case '.': {
                    this.handlePunctuation(maskPos, valueChar);
                    break;
                }
                case '_': {
                    this.handleAlphaNumPunctuation(maskPos, valueChar);
                    break;
                }
                case '*': {
                    this.handleDontCare(maskPos, valueChar);
                    break;
                }
                default: {
                    if (maskChar != valueChar) {
                        if (Character.isLetterOrDigit(valueChar)) {
                            ++maskPos;
                            continue block9;
                        }
                        throw new IllegalArgumentException(INVALID_VALUE);
                    }
                    inputValueChar = 42;
                }
            }
            if (inputValueChar == 32 && valueChar != ' ') {
                ++this.inputCharCount;
            }
            ++maskPos;
            ++valuePos;
        }
        return maskPos;
    }

    private void handleDontCare(int maskPos, char valueChar) {
        if (Character.isWhitespace(valueChar)) {
            throw new IllegalArgumentException(INVALID_NONWHITESPACE);
        }
        this.inputValue.setCharAt(maskPos, valueChar);
    }

    private void handleAlphaNumPunctuation(int maskPos, char valueChar) {
        if (!Character.isLetterOrDigit(valueChar) && !AbstractInputMaskValidator.isPunctuation(valueChar)) {
            throw new IllegalArgumentException(INVALID_ALPHA_PUNC_VALUE);
        }
        this.inputValue.setCharAt(maskPos, valueChar);
    }

    private void handlePunctuation(int maskPos, char valueChar) {
        if (!AbstractInputMaskValidator.isPunctuation(valueChar)) {
            throw new IllegalArgumentException(INVALID_PUNCTUATION_VALUE);
        }
        this.inputValue.setCharAt(maskPos, valueChar);
    }

    private void handleAlphaNumerical(int maskPos, char valueChar) {
        if (!Character.isLetterOrDigit(valueChar)) {
            throw new IllegalArgumentException(INVALID_ALPHANUMERICAL_VALUE);
        }
        this.inputValue.setCharAt(maskPos, valueChar);
    }

    private void handleLowercaseLetter(int maskPos, char valueChar) {
        if (!Character.isLetter(valueChar)) {
            throw new IllegalArgumentException(INVALID_LOWERCASE_VALUE);
        }
        this.inputValue.setCharAt(maskPos, Character.toLowerCase(valueChar));
    }

    private void handleUppercaseLetter(int maskPos, char valueChar) {
        if (!Character.isLetter(valueChar)) {
            throw new IllegalArgumentException(INVALID_UPPERCASE_VALUE);
        }
        this.inputValue.setCharAt(maskPos, Character.toUpperCase(valueChar));
    }

    private void handleDigit(int maskPos, char valueChar) {
        if (!Character.isDigit(valueChar)) {
            throw new IllegalArgumentException(INVALID_DIGIT_VALUE);
        }
        this.inputValue.setCharAt(maskPos, valueChar);
    }

    protected void clearText(int startPos, int length) {
        int i = startPos;
        while (i < startPos + length && i < this.inputValue.length()) {
            char c = this.maskPattern.charAt(i);
            if (AbstractInputMaskValidator.isPatternChar(c)) {
                if (this.inputValue.charAt(i) != ' ') {
                    --this.inputCharCount;
                }
                this.inputValue.setCharAt(i, ' ');
            }
            ++i;
        }
    }
}

