/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation.validator;

import com.richclientgui.toolbox.Messages;
import com.richclientgui.toolbox.validation.converter.IContentsStringConverter;
import com.richclientgui.toolbox.validation.validator.DateFieldValidator;
import java.text.MessageFormat;
import java.util.Date;

public class RangedDateFieldValidator
extends DateFieldValidator {
    private Date startRange;
    private Date endRange;

    public RangedDateFieldValidator(String maskPattern, IContentsStringConverter<Date> dateConverter, Date startDate, Date endDate) {
        super(maskPattern, dateConverter);
        this.startRange = startDate;
        this.endRange = endDate;
    }

    public Date getStartRange() {
        return this.startRange;
    }

    public void setStartRange(Date startRange) {
        this.startRange = startRange;
    }

    public Date getEndRange() {
        return this.endRange;
    }

    public void setEndRange(Date endRange) {
        this.endRange = endRange;
    }

    @Override
    public String getErrorMessage() {
        return MessageFormat.format(Messages.getString("RangedDateFieldValidator.message.error"), this.startRange, this.endRange);
    }

    @Override
    public boolean isContentsValid(Date contents) {
        return contents.equals(this.startRange) || contents.equals(this.endRange) || contents.after(this.startRange) && contents.before(this.endRange);
    }
}

