/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation.validator;

import com.richclientgui.toolbox.validation.validator.IFieldValidator;

public abstract class RangedNumberFieldValidator<T extends Number>
implements IFieldValidator<T> {
    private T minimum;
    private T maximum;

    protected RangedNumberFieldValidator(T minimum, T maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public T getMinimum() {
        return this.minimum;
    }

    public void setMinimum(T minimum) {
        this.minimum = minimum;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public void setMaximum(T maximum) {
        this.maximum = maximum;
    }

    @Override
    public boolean isValid(T contents) {
        if (contents == null) {
            return false;
        }
        double contentsValue = ((Number)contents).doubleValue();
        double minValue = ((Number)this.minimum).doubleValue();
        double maxValue = ((Number)this.maximum).doubleValue();
        return contentsValue >= minValue && contentsValue <= maxValue;
    }

    @Override
    public abstract String getErrorMessage();

    @Override
    public abstract String getWarningMessage();

    @Override
    public abstract boolean warningExist(T var1);
}

