/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

public final class JAXPNamespaceContextWrapper
implements NamespaceContext {
    private javax.xml.namespace.NamespaceContext fNamespaceContext;
    private SymbolTable fSymbolTable;
    private List<String> fPrefixes;
    private final Vector<String> fAllPrefixes = new Vector();
    private int[] fContext = new int[8];
    private int fCurrentContext;

    public JAXPNamespaceContextWrapper(SymbolTable symbolTable) {
        this.setSymbolTable(symbolTable);
    }

    public void setNamespaceContext(javax.xml.namespace.NamespaceContext context) {
        this.fNamespaceContext = context;
    }

    public javax.xml.namespace.NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public void setDeclaredPrefixes(List<String> prefixes) {
        this.fPrefixes = prefixes;
    }

    public List<String> getDeclaredPrefixes() {
        return this.fPrefixes;
    }

    @Override
    public String getURI(String prefix) {
        String uri;
        if (this.fNamespaceContext != null && (uri = this.fNamespaceContext.getNamespaceURI(prefix)) != null && !"".equals(uri)) {
            return this.fSymbolTable != null ? this.fSymbolTable.addSymbol(uri) : uri.intern();
        }
        return null;
    }

    @Override
    public String getPrefix(String uri) {
        if (this.fNamespaceContext != null) {
            String prefix;
            if (uri == null) {
                uri = "";
            }
            if ((prefix = this.fNamespaceContext.getPrefix(uri)) == null) {
                prefix = "";
            }
            return this.fSymbolTable != null ? this.fSymbolTable.addSymbol(prefix) : prefix.intern();
        }
        return null;
    }

    @Override
    public Enumeration<String> getAllPrefixes() {
        return Collections.enumeration(new TreeSet<String>(this.fAllPrefixes));
    }

    @Override
    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] contextarray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, contextarray, 0, this.fContext.length);
            this.fContext = contextarray;
        }
        this.fContext[++this.fCurrentContext] = this.fAllPrefixes.size();
        if (this.fPrefixes != null) {
            this.fAllPrefixes.addAll(this.fPrefixes);
        }
    }

    @Override
    public void popContext() {
        this.fAllPrefixes.setSize(this.fContext[this.fCurrentContext--]);
    }

    @Override
    public boolean declarePrefix(String prefix, String uri) {
        return true;
    }

    @Override
    public int getDeclaredPrefixCount() {
        return this.fPrefixes != null ? this.fPrefixes.size() : 0;
    }

    @Override
    public String getDeclaredPrefixAt(int index) {
        return this.fPrefixes.get(index);
    }

    @Override
    public void reset() {
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = 0;
        this.fAllPrefixes.clear();
    }
}

