/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.security;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.security.ControlUtils;
import su.artix.cashserver.security.GuiElementController;
import su.artix.cashserver.security.SecurityAction;
import su.artix.cashserver.security.SecurityController;
import su.artix.cashserver.security.utils.SecurityUtils;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.action.DirectoryExportActionGroup;

public class GuiElementControllerImpl
implements GuiElementController {
    private static final Logger log = LoggerFactory.getLogger(GuiElementControllerImpl.class);
    @Autowired
    private SecurityController securityController;
    private ControlUtils controlUtils = new ControlUtils();

    private void setVisibleToFields(List<ControlUtils.SecurityElement> controls, boolean collapse) {
        for (ControlUtils.SecurityElement element : controls) {
            this.setVisibleToField(element, collapse);
        }
    }

    private void setVisibleToField(ControlUtils.SecurityElement element, boolean collapse) {
        try {
            log.trace("work with filed id={}", (Object)element.getId());
            SecurityObject securityObject = new SecurityObject(element.getId());
            if (element.getElementType() == ControlUtils.SecurityElementType.CONTROL) {
                Control control = this.getControl(element);
                if (control != null && control.getVisible()) {
                    this.securityController.setVisibleToField(securityObject, control);
                }
                if (collapse && control.getLayoutData() instanceof GridData) {
                    ((GridData)control.getLayoutData()).exclude = false;
                }
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            Control control = this.getControl(element);
            control.setVisible(false);
            if (collapse && control.getLayoutData() instanceof GridData) {
                ((GridData)control.getLayoutData()).exclude = true;
            }
            log.debug("No permissions to read field {}", (Object)element.getId());
        }
    }

    private List<ControlUtils.SecurityElement> getActions(String prefix, Class<?> clazz, Object element) {
        Field field = FieldUtils.getField(clazz, (String)"commonActionGroup", (boolean)true);
        Object obj = null;
        try {
            obj = field.get(element);
            List controls = this.controlUtils.getControls(prefix, obj.getClass(), obj);
            if (obj instanceof DirectoryExportActionGroup) {
                controls.addAll(this.controlUtils.getControls(prefix, DirectoryEditActionGroup.class, obj));
                controls.addAll(this.controlUtils.getControls(prefix, DirectoryExportActionGroup.class, obj));
            }
            return controls;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void setEnabledToFields(List<ControlUtils.SecurityElement> controls) {
        for (ControlUtils.SecurityElement element : controls) {
            this.setEnabledToField(element);
        }
    }

    private void setEnabledToField(ControlUtils.SecurityElement element) {
        try {
            SecurityObject securityObject = new SecurityObject(element.getId());
            if (element.getElementType() == ControlUtils.SecurityElementType.ACTION) {
                if (((IAction)element.getValue()).isEnabled()) {
                    this.securityController.setEnabledToField(securityObject, (IAction)element.getValue());
                }
                if (element.getValue() instanceof SecurityAction) {
                    this.securityController.setEnabledToField(securityObject, (IAction)element.getValue());
                }
            } else {
                Control control = this.getControl(element);
                if (control != null && control.isEnabled()) {
                    this.securityController.setEnabledToField(securityObject, control);
                }
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            if (element.getElementType() == ControlUtils.SecurityElementType.ACTION) {
                ((IAction)element.getValue()).setEnabled(false);
                if (element.getValue() instanceof SecurityAction) {
                    ((SecurityAction)element.getValue()).setSecurityEnabled(false);
                }
            } else {
                this.getControl(element).setEnabled(false);
            }
            log.debug("No permissions to write field {}", (Object)element.getId());
        }
    }

    private Control getControl(ControlUtils.SecurityElement element) {
        Control control = null;
        if (element.getValue() instanceof Control) {
            control = (Control)element.getValue();
        } else if (element.getValue() instanceof ComboViewer) {
            control = ((ComboViewer)element.getValue()).getControl();
        }
        return control;
    }

    public void applyRightsPerspective(List<? extends Object> buttons, boolean isCashServer, boolean isVisiblePicklistPerspective) {
        String viewMode = "cash";
        if (isCashServer) {
            viewMode = "server";
        }
        for (Button button : buttons) {
            String perspectiveId = ((IPerspectiveDescriptor)button.getData()).getId();
            if (Boolean.FALSE.equals(button.getData(viewMode)) || Boolean.FALSE.equals(button.getData("dbVersionValid"))) {
                GuiElementControllerImpl.setVisiblePerspective(button, perspectiveId, false);
                continue;
            }
            if (!"ru.ssa.artixadmin.perspectives.PicklistPerspective".equals(perspectiveId)) continue;
            GuiElementControllerImpl.setVisiblePerspective(button, perspectiveId, isVisiblePicklistPerspective);
        }
    }

    private static void setVisiblePerspective(Button button, String perspectiveId, boolean isVisible) {
        button.setVisible(isVisible);
        ArrayList<String> perspectiveIds = new ArrayList<String>(1);
        perspectiveIds.add(perspectiveId);
        SecurityUtils.checkPerspectives(perspectiveIds);
        if (button.getLayoutData() instanceof GridData) {
            ((GridData)button.getLayoutData()).exclude = !isVisible;
        }
    }

    public boolean hasRightsPerspective(String id) {
        SecurityObject element = new SecurityObject(id);
        try {
            this.securityController.canWithField(element);
        }
        catch (AccessDeniedException accessDeniedException) {
            return false;
        }
        return true;
    }

    public void applyRights(Class<?> clazz, Object element, String selector) {
        List controls = this.controlUtils.getControls("", clazz, element);
        if (TitleAreaDialog.class.isAssignableFrom(clazz)) {
            controls.addAll(this.controlUtils.getControlsOfSuperclass("", clazz, element));
        }
        if (ViewPart.class.isAssignableFrom(clazz)) {
            controls.addAll(this.getActions(clazz.getName(), clazz, element));
            controls.addAll(this.controlUtils.getPanel("", clazz, element));
        }
        this.setVisibleToFields(controls, false);
        this.setEnabledToFields(controls);
    }

    public void applyRights(Class<?> clazz, Object element) {
        this.applyRights(clazz, element, null);
    }
}

