/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Catalog;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventCatalogPK;

@Entity
@Table(name="tmccatalog")
@MappedSuperclass
public class InventCatalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private InventCatalogPK tmccatalogPK = new InventCatalogPK();
    @ManyToOne
    @JoinColumn(name="catalogid", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Catalog catalog;
    @Column(name="catalogid", insertable=false, updatable=false)
    private String catalogcode;
    @Column(name="tmccode", insertable=false, updatable=false)
    private String tmccode;
    @ManyToOne
    @JoinColumn(name="tmccode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Invent.class)
    @NotNull
    private Invent tmc;

    public String getTmccode() {
        return this.tmccode;
    }

    public void setTmccode(String tmccode) {
        this.tmccode = tmccode;
    }

    protected InventCatalog() {
    }

    public InventCatalog(Catalog catalog, Invent tmc) {
        this.setCatalog(catalog);
        this.setTmc(tmc);
    }

    public InventCatalogPK getTmccatalogPK() {
        return this.tmccatalogPK;
    }

    public Invent getTmc() {
        return this.tmc;
    }

    public void setTmccatalogPK(InventCatalogPK tmccatalogPK) {
        this.tmccatalogPK = tmccatalogPK;
    }

    public void setTmc(Invent tmc) {
        this.tmc = tmc;
        if (tmc != null) {
            this.tmccatalogPK.setTmccode(tmc.getCode());
        } else {
            this.tmccatalogPK.setTmccode(null);
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        if (catalog != null) {
            this.tmccatalogPK.setCatalogid(catalog.getCatalogid());
        } else {
            this.tmccatalogPK.setCatalogid(null);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tmccatalog [tmccatalogPK=");
        builder.append(this.tmccatalogPK);
        builder.append(", tmc=");
        builder.append(this.tmc);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.tmccatalogPK == null ? 0 : this.tmccatalogPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InventCatalog other = (InventCatalog)obj;
        return !(this.tmccatalogPK == null ? other.tmccatalogPK != null : !this.tmccatalogPK.equals(other.tmccatalogPK));
    }

    public String getCatalogcode() {
        return this.catalogcode;
    }

    public void setCatalogcode(String catalogcode) {
        this.catalogcode = catalogcode;
    }

    public void setImage(String data) {
    }

    public String getImage() {
        return null;
    }
}

