/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.dao.FilteredCollection;
import ru.ssa.cashadmin.domain.payment.Agent;
import ru.ssa.cashadmin.domain.payment.Defcode;

@Entity
@Table(name="region")
@MappedSuperclass
public class Region
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Integer regionid;
    @NotNull
    @Length(max=100, min=1)
    private String regioncode;
    @NotNull
    private String agentcode;
    @ManyToOne
    @JoinColumn(name="agentcode", referencedColumnName="code", insertable=false, updatable=false)
    @NotNull
    @NotFound(action=NotFoundAction.IGNORE)
    private Agent agent;
    @Length(max=255)
    private String name;
    @OneToMany(mappedBy="regionid", cascade={CascadeType.ALL})
    @FilteredCollection
    private List<Defcode> defcodes = new ArrayList<Defcode>();

    protected Region() {
    }

    public Integer getRegionid() {
        return this.regionid;
    }

    public void setRegionid(Integer regionid) {
        this.regionid = regionid;
    }

    public String getRegioncode() {
        return this.regioncode;
    }

    public void setRegioncode(String regioncode) {
        this.regioncode = regioncode;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
        this.agentcode = agent != null ? agent.getCode() : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefcodes(List<Defcode> defcodes) {
        this.defcodes = defcodes;
    }

    public List<Defcode> getDefcodes() {
        return this.defcodes;
    }

    public String getAgentcode() {
        return this.agentcode;
    }

    public void setAgentcode(String agentcode) {
        this.agentcode = agentcode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.regionid == null ? 0 : this.regionid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        return !(this.regionid == null ? other.regionid != null : !this.regionid.equals(other.regionid));
    }

    public String toString() {
        return "Region [regionid=" + this.regionid + ", regioncode=" + this.regioncode + ", agentcode=" + this.agentcode + ", name=" + this.name + "]";
    }
}

