/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import com.rits.cloning.Cloner;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import su.artix.yuki.editors.EditorMode;
import su.artix.yuki.editors.GenericModel;
import su.artix.yuki.editors.GenericModelImpl;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public abstract class CommonEditorComposite<T>
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(CommonEditorComposite.class);
    protected IObservableValue autoChangedValue;
    private final DataBindingContext bindingContext;
    private final IObservableValue masterValue;
    private Class<T> clazz;
    private final GenericModel<T> genericModel;
    private T model;
    private EditorMode editorMode;

    public CommonEditorComposite(Composite parent, int style) {
        super(parent, style);
        this.genericModel = new GenericModelImpl<Object>(null);
        this.bindingContext = new DataBindingContext();
        this.masterValue = PojoObservables.observeValue(this.genericModel, (String)"modelObject");
    }

    public CommonEditorComposite(Composite parent, int style, Class<T> clazz, T model) {
        super(parent, style);
        this.clazz = clazz;
        this.model = this.getActualModel(model);
        this.genericModel = new GenericModelImpl<T>(this.model);
        this.bindingContext = new DataBindingContext();
        this.masterValue = PojoObservables.observeValue(this.genericModel, (String)"modelObject");
    }

    protected String getNotNullStr(String str) {
        return str == null ? "" : str;
    }

    protected T getActualModel(T model) {
        try {
            Cloner cloner = new Cloner();
            cloner.dontCloneInstanceOf(new Class[]{PropertyChangeSupport.class});
            return (T)cloner.deepClone(model);
        }
        catch (Exception e) {
            log.error("could't clone", (Throwable)e);
            return model;
        }
    }

    protected int getIntValue(BigDecimal value, int valueRank) {
        if (value != null) {
            return (int)(value.doubleValue() * Math.pow(10.0, valueRank));
        }
        return 0;
    }

    protected BigDecimal getBigDecimalValue(int value, int valueRank) {
        return new BigDecimal((double)value / Math.pow(10.0, valueRank));
    }

    protected Date getDateValue(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(year, month, day);
        return c.getTime();
    }

    public void initialize() {
    }

    public IObservableValue getAutoChangedValue() {
        return this.autoChangedValue;
    }

    public IObservableValue setAutoChangedValue(IObservableValue autoChangedValue) {
        this.autoChangedValue = autoChangedValue;
        return this.autoChangedValue;
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void bindValues() {
    }

    public void updateBind() {
        this.masterValue.setValue(this.model);
        this.bindingContext.updateModels();
    }

    protected IObservableValue getMasterValue() {
        return this.masterValue;
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public IObservableValue getDetailValue(String propertyName) {
        Class actualClazz = LibActivator.getDefault().getActualClassResolver().getActual(this.clazz);
        log.trace("detail value for class:{},property:{}", (Object)actualClazz, (Object)propertyName);
        return PojoProperties.value((Class)actualClazz, (String)propertyName).observeDetail(this.masterValue);
    }

    public T getActualModel() {
        return this.getActualModel(this.getModel());
    }

    public void initDefault(T model) {
    }

    public EditorMode getEditorMode() {
        return this.editorMode;
    }

    public void setEditorMode(EditorMode editorMode) {
        this.editorMode = editorMode;
    }

    protected final DirectoryEditModel<T> getDirectoryModel() {
        return ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }
}

