/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.commandoperation;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.commandoperation.ChooseShemePage;
import ru.ssa.artixadmin.editors.commandoperation.CommandConstructor;
import ru.ssa.artixadmin.editors.commandoperation.CommandSheme;
import ru.ssa.artixadmin.editors.commandoperation.FRdocConstructor;
import ru.ssa.artixadmin.editors.commandoperation.ReportConstructor;
import ru.ssa.artixadmin.editors.commandoperation.ShellConstructor;
import ru.ssa.artixadmin.editors.commandoperation.SummaryCommandPage;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.DuplicateValueException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class CommandOperationWizard
extends Wizard {
    private static final Logger log = LoggerFactory.getLogger(CommandOperationWizard.class);
    private String command = "";
    boolean canFinish = false;
    private Actionparameter actionparameter;
    private boolean create;
    private CommandSheme commandSheme;

    public CommandOperationWizard(Actionparameter actionparameter, boolean create) {
        this.actionparameter = actionparameter;
        this.create = create;
        actionparameter.setActionparametercode((Integer)ModelActivator.getDefault().getModelProvider().getDirectoryModel(Actionparameter.class).getNextId());
        if (actionparameter.getParametervalue() != null) {
            String sheme = actionparameter.getParametervalue().split("://")[0];
            this.commandSheme = CommandSheme.valueOf(sheme);
        }
    }

    public void addPages() {
        boolean frdoc = true;
        boolean shell = true;
        boolean report = true;
        this.addPage((IWizardPage)new ChooseShemePage(this.actionparameter, this.create));
        if (this.commandSheme == CommandSheme.report) {
            report = false;
        }
        this.addPage((IWizardPage)new ReportConstructor(this.actionparameter, report));
        if (this.commandSheme == CommandSheme.shell) {
            shell = false;
        }
        this.addPage((IWizardPage)new ShellConstructor(this.actionparameter, shell));
        if (this.commandSheme == CommandSheme.frdoc) {
            frdoc = false;
        }
        this.addPage((IWizardPage)new FRdocConstructor(this.actionparameter, frdoc));
        this.addPage((IWizardPage)new SummaryCommandPage());
    }

    public boolean performFinish() {
        try {
            this.setCommand();
            this.command = ((CommandConstructor)this.getPage("SummaryCommand")).getCommand();
            this.saveAction();
        }
        catch (ExecuteQueryException e) {
            log.error("SQL Query error", (Throwable)e);
        }
        return true;
    }

    private void saveAction() throws ExecuteQueryException {
        this.actionparameter.setParametervalue(this.command);
        DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Actionparameter.class);
        if (this.create) {
            Actionparameter state = (Actionparameter)LibActivator.getDefault().getActualClassResolver().getInstance(Actionparameter.class);
            state.setCmaction(this.actionparameter.getCmaction());
            Integer max = (Integer)directoryModel.getNext("parameterorder", (Object)state);
            this.actionparameter.setParameterorder(max);
            try {
                directoryModel.doAdd((Object)this.actionparameter);
            }
            catch (DuplicateValueException e) {
                log.error("Duplicate value error", (Throwable)e);
            }
        } else {
            directoryModel.doUpdate((Object)this.actionparameter);
        }
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    private ChooseShemePage getChooseShemePage() {
        return (ChooseShemePage)this.getPage("ChooseSheme");
    }

    private FRdocConstructor getFRdocConstructor() {
        return (FRdocConstructor)this.getPage("FRdocConstructor");
    }

    private ShellConstructor getShellConstructor() {
        return (ShellConstructor)this.getPage("ShellConstructor");
    }

    private ReportConstructor getReportConstructor() {
        return (ReportConstructor)this.getPage("ReportConstructor");
    }

    public boolean performCancel() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        SummaryCommandPage summary;
        IWizardPage nextPage;
        if (page instanceof ChooseShemePage) {
            this.canFinish = true;
            ChooseShemePage chooseShemePage = (ChooseShemePage)page;
            if (chooseShemePage.getCommandSheme() == CommandSheme.shell) {
                return this.getShellConstructor();
            }
            if (chooseShemePage.getCommandSheme() == CommandSheme.report) {
                return this.getReportConstructor();
            }
            if (chooseShemePage.getCommandSheme() == CommandSheme.frdoc) {
                return this.getFRdocConstructor();
            }
        }
        if ((nextPage = super.getNextPage(page)) instanceof SummaryCommandPage) {
            summary = (SummaryCommandPage)nextPage;
            this.setCommand();
            summary.setCommand(this.command);
        }
        if (page instanceof ShellConstructor) {
            summary = (SummaryCommandPage)this.getPage("SummaryCommand");
            this.setCommand();
            summary.setCommand(this.command);
            return summary;
        }
        if (page instanceof FRdocConstructor) {
            summary = (SummaryCommandPage)this.getPage("SummaryCommand");
            this.setCommand();
            summary.setCommand(this.command);
            return summary;
        }
        if (page instanceof ReportConstructor) {
            summary = (SummaryCommandPage)this.getPage("SummaryCommand");
            this.setCommand();
            summary.setCommand(this.command);
            return summary;
        }
        return nextPage;
    }

    private void setCommand() {
        CommandSheme sheme = this.getChooseShemePage().getCommandSheme();
        if (sheme == CommandSheme.frdoc) {
            this.command = this.getFRdocConstructor().getCommand();
        }
        if (sheme == CommandSheme.shell) {
            this.command = this.getShellConstructor().getCommand();
        }
        if (sheme == CommandSheme.report) {
            this.command = this.getReportConstructor().getCommand();
        }
    }
}

