/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation.converter;

import com.richclientgui.toolbox.Messages;
import com.richclientgui.toolbox.validation.converter.IContentsStringConverter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateStringConverter
implements IContentsStringConverter<Date> {
    private static final DateFormat[] DATE_FORMATTERS;
    private DateFormat defaultFormatter = DATE_FORMATTERS[0];

    static {
        DateFormat[] dateFormatArray = DATE_FORMATTERS = new DateFormat[]{new SimpleDateFormat(Messages.getString("DateStringConverter.format.datetime1")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.datetime2")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.datetime3")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.datetime4")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.date1")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.date2")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.time_HHmmss")), new SimpleDateFormat(Messages.getString("DateStringConverter.format.time_HHmm")), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateInstance(3), DateFormat.getTimeInstance(3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getTimeInstance(2), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateInstance(2), DateFormat.getTimeInstance(3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getTimeInstance(2)};
        int n = DATE_FORMATTERS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat df = dateFormatArray[n2];
            df.setLenient(false);
            ++n2;
        }
    }

    public void setDefaultDateFormat(DateFormat defaultFormat) {
        this.defaultFormatter = defaultFormat;
        defaultFormat.setLenient(false);
    }

    public static int getDateFormattersSize() {
        return DATE_FORMATTERS.length;
    }

    public static DateFormat getDateFormat(int index) {
        return DATE_FORMATTERS[index];
    }

    @Override
    public Date convertFromString(String value) {
        return this.parse(value);
    }

    @Override
    public String convertToString(Date contents) {
        return this.defaultFormatter.format(contents);
    }

    protected Date parse(String dateString) {
        if (dateString == null) {
            return null;
        }
        Date parsedDate = DateStringConverter.parse(dateString, this.defaultFormatter);
        if (parsedDate != null) {
            return parsedDate;
        }
        DateFormat[] dateFormatArray = DATE_FORMATTERS;
        int n = DATE_FORMATTERS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat dateTimeFormat = dateFormatArray[n2];
            parsedDate = DateStringConverter.parse(dateString, dateTimeFormat);
            if (parsedDate != null) {
                return parsedDate;
            }
            ++n2;
        }
        return DateStringConverter.parseMillisecondsDate(dateString);
    }

    private static Date parseMillisecondsDate(String dateString) {
        try {
            long millisecs = Long.parseLong(dateString);
            return new Date(millisecs);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private static Date parse(String dateString, DateFormat dateTimeFormat) {
        ParsePosition parsePos = new ParsePosition(0);
        if (dateString == null) {
            return null;
        }
        Date date = dateTimeFormat.parse(dateString, parsePos);
        if (parsePos.getErrorIndex() != -1 || parsePos.getIndex() != dateString.length()) {
            return null;
        }
        return date;
    }

    public DateFormat getDefaultDateFormat() {
        return this.defaultFormatter;
    }
}

