/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

public class GrayableButton
extends Button {
    Image image;
    Image grayImage;
    private static final String GRAY_IMAGE = "GrayableButton.GrayImage";

    public GrayableButton(Image image) {
        this(image, null);
    }

    public GrayableButton(Image image, Image grayImage) {
        super(image);
        this.image = image;
        this.grayImage = XYGraphMediaFactory.getInstance().getRegisteredImage(GRAY_IMAGE + image.toString());
        if (this.grayImage == null) {
            this.grayImage = SWT.getPlatform().startsWith("rap") ? (grayImage != null ? grayImage : image) : new Image(null, image, 2);
            XYGraphMediaFactory.getInstance().registerImage(GRAY_IMAGE + image.toString(), this.grayImage);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        if (value) {
            this.setContents((IFigure)new ImageFigure(this.image));
        } else {
            this.setContents((IFigure)new ImageFigure(this.grayImage));
        }
    }
}

