/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.rangeSlider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class RangeSlider
extends Canvas {
    private int minimum = 0;
    private int maximum = 100;
    private int lowerValue = 0;
    private int upperValue = 100;
    private final List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private final Image slider;
    private final Image sliderHover;
    private final Image sliderDrag;
    private final Image sliderSelected;
    private final Image vSlider;
    private final Image vSliderHover;
    private final Image vSliderDrag;
    private final Image vSliderSelected;
    private int orientation;
    private int increment = 1;
    private int pageIncrement = 10;
    private SELECTED_KNOB lastSelected = SELECTED_KNOB.NONE;
    private boolean dragInProgress;
    private Point coordUpper;
    private boolean upperHover;
    private Point coordLower;
    private boolean lowerHover;
    private int previousUpperValue;
    private int previousLowerValue;

    public RangeSlider(Composite composite, int n) {
        super(composite, 0x20000000 | ((n & 0x800) == 2048 ? 2048 : 0));
        this.slider = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-normal.png"));
        this.sliderHover = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-hover.png"));
        this.sliderDrag = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-drag.png"));
        this.sliderSelected = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-selected.png"));
        this.vSlider = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-normal.png"));
        this.vSliderHover = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-hover.png"));
        this.vSliderDrag = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-drag.png"));
        this.vSliderSelected = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-selected.png"));
        this.orientation = (n & 0x200) == 512 ? 512 : 256;
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.slider);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.sliderHover);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.sliderDrag);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.sliderSelected);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.vSlider);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.vSliderHover);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.vSliderDrag);
                SWTGraphicUtil.safeDispose((Resource)RangeSlider.this.vSliderSelected);
            }
        });
        this.addMouseListeners();
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                RangeSlider.this.handleKeyDown(event);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                RangeSlider.this.drawWidget(paintEvent);
            }
        });
    }

    private void addMouseListeners() {
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RangeSlider.this.handleMouseDown(event);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                RangeSlider.this.handleMouseUp(event);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                RangeSlider.this.handleMouseMove(event);
            }
        });
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                RangeSlider.this.handleMouseWheel(event);
            }
        });
    }

    private void handleMouseDown(Event event) {
        if (this.upperHover) {
            this.dragInProgress = true;
            this.lastSelected = SELECTED_KNOB.UPPER;
            this.previousUpperValue = this.upperValue;
            return;
        }
        if (this.lowerHover) {
            this.dragInProgress = true;
            this.lastSelected = SELECTED_KNOB.LOWER;
            this.previousLowerValue = this.lowerValue;
            return;
        }
        this.dragInProgress = false;
        this.lastSelected = SELECTED_KNOB.NONE;
    }

    private void handleMouseUp(Event event) {
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        if (!this.fireSelectionListeners(event)) {
            if (this.lastSelected == SELECTED_KNOB.UPPER) {
                this.upperValue = this.previousUpperValue;
            } else {
                this.lowerValue = this.previousLowerValue;
            }
            this.redraw();
        }
    }

    private boolean fireSelectionListeners(Event event) {
        for (SelectionListener selectionListener : this.listeners) {
            SelectionEvent selectionEvent = new SelectionEvent(event);
            selectionListener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    private void handleMouseMove(Event event) {
        int n = event.x;
        int n2 = event.y;
        Image image = this.orientation == 256 ? this.slider : this.vSlider;
        this.upperHover = n >= this.coordUpper.x && n <= this.coordUpper.x + image.getBounds().width && n2 >= this.coordUpper.y && n2 <= this.coordUpper.y + image.getBounds().height;
        boolean bl = this.lowerHover = n >= this.coordLower.x && n <= this.coordLower.x + image.getBounds().width && n2 >= this.coordLower.y && n2 <= this.coordLower.y + image.getBounds().height;
        if (this.dragInProgress) {
            if (this.orientation == 256) {
                int n3 = (int)(((float)n - 9.0f) / this.computePixelSizeForHorizonalSlider()) + this.minimum;
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = (int)(Math.ceil(n3 / this.increment) * (double)this.increment) - this.increment;
                    this.checkUpperValue();
                } else {
                    this.lowerValue = (int)(Math.ceil(n3 / this.increment) * (double)this.increment) - this.increment;
                    this.checkLowerValue();
                }
            } else {
                int n4 = (int)(((float)n2 - 9.0f) / this.computePixelSizeForVerticalSlider()) + this.minimum;
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = (int)(Math.ceil(n4 / this.increment) * (double)this.increment) - this.increment;
                    this.checkUpperValue();
                } else {
                    this.lowerValue = (int)(Math.ceil(n4 / this.increment) * (double)this.increment) - this.increment;
                    this.checkLowerValue();
                }
            }
        }
        this.redraw();
    }

    private void handleMouseWheel(Event event) {
        if (this.lastSelected == SELECTED_KNOB.NONE) {
            return;
        }
        if (this.lastSelected == SELECTED_KNOB.LOWER) {
            this.lowerValue += event.count * this.increment;
            this.checkLowerValue();
            this.redraw();
        } else {
            this.upperValue += event.count * this.increment;
            this.checkUpperValue();
            this.redraw();
        }
    }

    private void checkLowerValue() {
        if (this.lowerValue < this.minimum) {
            this.lowerValue = this.minimum;
        }
        if (this.lowerValue > this.maximum) {
            this.lowerValue = this.maximum;
        }
        if (this.lowerValue > this.upperValue) {
            this.lowerValue = this.upperValue;
        }
    }

    private void checkUpperValue() {
        if (this.upperValue < this.minimum) {
            this.upperValue = this.minimum;
        }
        if (this.upperValue > this.maximum) {
            this.upperValue = this.maximum;
        }
        if (this.upperValue < this.lowerValue) {
            this.upperValue = this.lowerValue;
        }
    }

    private void drawWidget(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        paintEvent.gc.setAdvanced(true);
        paintEvent.gc.setAntialias(1);
        if (this.orientation == 256) {
            this.drawHorizontalRangeSlider(paintEvent.gc);
        } else {
            this.drawVerticalRangeSlider(paintEvent.gc);
        }
    }

    private void drawHorizontalRangeSlider(GC gC) {
        this.drawBackgroundHorizontal(gC);
        this.drawBarsHorizontal(gC);
        this.coordUpper = this.drawHorizontalKnob(gC, this.upperValue, true);
        this.coordLower = this.drawHorizontalKnob(gC, this.lowerValue, false);
    }

    private void drawBackgroundHorizontal(GC gC) {
        Rectangle rectangle = this.getClientArea();
        gC.setBackground(this.getBackground());
        gC.fillRectangle(rectangle);
        if (this.isEnabled()) {
            gC.setForeground(this.getForeground());
        } else {
            gC.setForeground(this.getDisplay().getSystemColor(15));
        }
        gC.drawRoundRectangle(9, 9, rectangle.width - 20, rectangle.height - 20, 3, 3);
        float f = this.computePixelSizeForHorizonalSlider();
        int n = (int)(f * (float)this.lowerValue);
        int n2 = (int)(f * (float)this.upperValue);
        if (this.isEnabled()) {
            gC.setBackground(this.getForeground());
        } else {
            gC.setBackground(this.getDisplay().getSystemColor(15));
        }
        gC.fillRectangle(12 + n, 9, n2 - n - 6, rectangle.height - 20);
    }

    private float computePixelSizeForHorizonalSlider() {
        return ((float)this.getClientArea().width - 20.0f) / (float)(this.maximum - this.minimum);
    }

    private void drawBarsHorizontal(GC gC) {
        Rectangle rectangle = this.getClientArea();
        if (this.isEnabled()) {
            gC.setForeground(this.getForeground());
        } else {
            gC.setForeground(this.getDisplay().getSystemColor(15));
        }
        float f = this.computePixelSizeForHorizonalSlider();
        for (int i = 1; i < 10; ++i) {
            int n = (int)(9.0f + f * (float)(this.maximum - this.minimum) / 10.0f * (float)i);
            gC.drawLine(n, 4, n, 7);
            gC.drawLine(n, rectangle.height - 6, n, rectangle.height - 9);
        }
    }

    private Point drawHorizontalKnob(GC gC, int n, boolean bl) {
        float f = this.computePixelSizeForHorizonalSlider();
        int n2 = (int)(f * (float)n);
        Image image = bl ? (this.upperHover ? (this.dragInProgress ? this.sliderDrag : this.sliderHover) : (this.lastSelected == SELECTED_KNOB.UPPER ? this.sliderSelected : this.slider)) : (this.lowerHover ? (this.dragInProgress ? this.sliderDrag : this.sliderHover) : (this.lastSelected == SELECTED_KNOB.LOWER ? this.sliderSelected : this.slider));
        if (this.isEnabled()) {
            gC.drawImage(image, n2 + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
        } else {
            Image image2 = new Image((Device)this.getDisplay(), image, 1);
            gC.drawImage(image2, n2 + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
            image2.dispose();
        }
        return new Point(n2 + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
    }

    private void drawVerticalRangeSlider(GC gC) {
        this.drawBackgroundVertical(gC);
        this.drawBarsVertical(gC);
        this.coordUpper = this.drawVerticalKnob(gC, this.upperValue, true);
        this.coordLower = this.drawVerticalKnob(gC, this.lowerValue, false);
    }

    private void drawBackgroundVertical(GC gC) {
        Rectangle rectangle = this.getClientArea();
        gC.setBackground(this.getBackground());
        gC.fillRectangle(rectangle);
        if (this.isEnabled()) {
            gC.setForeground(this.getForeground());
        } else {
            gC.setForeground(this.getDisplay().getSystemColor(15));
        }
        gC.drawRoundRectangle(9, 9, rectangle.width - 20, rectangle.height - 20, 3, 3);
        float f = this.computePixelSizeForVerticalSlider();
        int n = (int)(f * (float)this.lowerValue);
        int n2 = (int)(f * (float)this.upperValue);
        if (this.isEnabled()) {
            gC.setBackground(this.getForeground());
        } else {
            gC.setBackground(this.getDisplay().getSystemColor(15));
        }
        gC.fillRectangle(9, 12 + n, rectangle.width - 20, n2 - n - 6);
    }

    private float computePixelSizeForVerticalSlider() {
        return ((float)this.getClientArea().height - 20.0f) / (float)(this.maximum - this.minimum);
    }

    private void drawBarsVertical(GC gC) {
        Rectangle rectangle = this.getClientArea();
        if (this.isEnabled()) {
            gC.setForeground(this.getForeground());
        } else {
            gC.setForeground(this.getDisplay().getSystemColor(15));
        }
        float f = this.computePixelSizeForVerticalSlider();
        for (int i = 1; i < 10; ++i) {
            int n = (int)(9.0f + f * (float)(this.maximum - this.minimum) / 10.0f * (float)i);
            gC.drawLine(4, n, 7, n);
            gC.drawLine(rectangle.width - 6, n, rectangle.width - 9, n);
        }
    }

    private Point drawVerticalKnob(GC gC, int n, boolean bl) {
        float f = this.computePixelSizeForVerticalSlider();
        int n2 = (int)(f * (float)n);
        Image image = bl ? (this.upperHover ? (this.dragInProgress ? this.vSliderDrag : this.vSliderHover) : (this.lastSelected == SELECTED_KNOB.UPPER ? this.vSliderSelected : this.vSlider)) : (this.lowerHover ? (this.dragInProgress ? this.vSliderDrag : this.vSliderHover) : (this.lastSelected == SELECTED_KNOB.LOWER ? this.vSliderSelected : this.vSlider));
        if (this.isEnabled()) {
            gC.drawImage(image, this.getClientArea().width / 2 - 8, n2 + 2);
        } else {
            Image image2 = new Image((Device)this.getDisplay(), image, 1);
            gC.drawImage(image2, this.getClientArea().width / 2 - 8, n2 + 2);
            image2.dispose();
        }
        return new Point(this.getClientArea().width / 2 - 8, n2 + 2);
    }

    private void handleKeyDown(Event event) {
        boolean bl = false;
        if (this.lastSelected == SELECTED_KNOB.NONE) {
            this.lastSelected = SELECTED_KNOB.LOWER;
        }
        switch (event.keyCode) {
            case 0x1000007: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = this.minimum;
                } else {
                    this.lowerValue = this.minimum;
                }
                bl = true;
                break;
            }
            case 0x1000008: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = this.maximum;
                } else {
                    this.lowerValue = this.maximum;
                }
                bl = true;
                break;
            }
            case 0x1000005: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue += this.pageIncrement;
                } else {
                    this.lowerValue += this.pageIncrement;
                }
                bl = true;
                break;
            }
            case 0x1000006: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue -= this.pageIncrement;
                } else {
                    this.lowerValue -= this.pageIncrement;
                }
                bl = true;
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue -= this.increment;
                } else {
                    this.lowerValue -= this.increment;
                }
                bl = true;
                break;
            }
            case 0x1000002: 
            case 0x1000004: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue += this.increment;
                } else {
                    this.lowerValue += this.increment;
                }
                bl = true;
            }
        }
        if (bl) {
            if (this.lastSelected == SELECTED_KNOB.UPPER) {
                this.checkUpperValue();
            } else {
                this.checkLowerValue();
            }
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.listeners.add(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.checkWidget();
        if (this.orientation == 256) {
            n4 = n < 100 ? 100 : n;
            n3 = n2 < 30 ? 30 : n2;
        } else {
            n4 = n < 30 ? 30 : n;
            n3 = n2 < 100 ? 100 : n2;
        }
        return new Point(n4, n3);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getLowerValue() {
        this.checkWidget();
        return this.lowerValue;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int[] getSelection() {
        this.checkWidget();
        int[] nArray = new int[]{this.lowerValue, this.upperValue};
        return nArray;
    }

    public int getUpperValue() {
        this.checkWidget();
        return this.upperValue;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.listeners.remove(selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        this.increment = n;
        this.redraw();
    }

    public void setLowerValue(int n) {
        this.checkWidget();
        if (this.minimum <= n && n <= this.maximum && n <= this.upperValue) {
            this.lowerValue = n;
        }
        this.redraw();
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (this.minimum <= n) {
            this.maximum = n;
            if (this.lowerValue >= this.maximum) {
                this.lowerValue = this.maximum;
            }
            if (this.upperValue >= this.maximum) {
                this.upperValue = this.maximum;
            }
        }
        this.redraw();
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (this.maximum >= n) {
            this.minimum = n;
            if (this.lowerValue <= this.minimum) {
                this.lowerValue = this.minimum;
            }
            if (this.upperValue <= this.minimum) {
                this.upperValue = this.minimum;
            }
        }
        this.redraw();
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        this.pageIncrement = n;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        this.setLowerValue(nArray[0]);
        this.setUpperValue(nArray[1]);
        this.checkUpperValue();
        this.checkLowerValue();
        this.redraw();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.setLowerValue(n);
        this.setUpperValue(n2);
    }

    public void setUpperValue(int n) {
        this.checkWidget();
        if (this.minimum <= n && n <= this.maximum && n >= this.lowerValue) {
            this.upperValue = n;
        }
        this.redraw();
    }

    private static enum SELECTED_KNOB {
        NONE,
        UPPER,
        LOWER;

    }
}

